/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.resources;

import ic2.core.IC2;
import ic2.core.platform.lang.ILocaleBlock;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.ITexturedBlock;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBlockStateLoader;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.IMetaSoundBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMetal
extends Block
implements IBootable,
IMetaSoundBlock,
ITexturedBlock,
IBlockStateLoader,
ILocaleBlock {
    static PropertyBool ore = PropertyBool.func_177716_a((String)"ore");
    static PropertyInteger metadata = PropertyInteger.func_177719_a((String)"metadata", (int)0, (int)15);

    public BlockMetal() {
        super(Material.field_151576_e);
        this.func_149711_c(4.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)ore, (Comparable)Boolean.valueOf(true)));
        this.setHarvestLevel("pickaxe", 1, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(0)));
        this.setHarvestLevel("pickaxe", 1, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(1)));
        this.setHarvestLevel("pickaxe", 2, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(2)));
        this.setHarvestLevel("pickaxe", 2, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(3)));
        this.setHarvestLevel("pickaxe", 1, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(7)));
        this.setHarvestLevel("pickaxe", 1, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(8)));
        this.setHarvestLevel("pickaxe", 2, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(9)));
        this.setHarvestLevel("pickaxe", 2, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(10)));
        this.setHarvestLevel("pickaxe", 2, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(11)));
        this.setHarvestLevel("pickaxe", 0, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(12)));
    }

    public String func_149739_a() {
        return this.getName().getUnlocalized();
    }

    public String func_149732_F() {
        return this.getName().getLocalized();
    }

    @Override
    public LocaleComp getName() {
        return Ic2BlockLang.metalBlock;
    }

    @Override
    public SoundType getSoundFromState(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)ore)).booleanValue()) {
            return null;
        }
        return SoundType.field_185852_e;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        int meta = (Integer)blockState.func_177229_b((IProperty)metadata);
        if (meta == 0 || meta == 1) {
            return 3.0f;
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        if (state != null) {
            int meta = (Integer)state.func_177229_b((IProperty)metadata);
            if (meta == 0 || meta == 1) {
                return 5.0f;
            }
            if (meta == 2) {
                return 6.0f;
            }
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        IBlockState state = worldObj.func_180495_p(pos);
        return (Boolean)state.func_177229_b((IProperty)ore) == false;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)metadata);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)ore, (Comparable)Boolean.valueOf(meta < 4));
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox(IBlockState state) {
        return field_185505_j;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureFromState(IBlockState state, EnumFacing par1) {
        int meta = (Integer)state.func_177229_b((IProperty)metadata);
        TextureAtlasSprite[] array = Ic2Icons.getTextures("b0");
        switch (meta) {
            case 0: {
                return array[32];
            }
            case 1: {
                return array[33];
            }
            case 2: {
                return array[34];
            }
            case 3: {
                return array[48];
            }
            case 7: {
                return array[93];
            }
            case 8: {
                return array[94];
            }
            case 9: {
                return array[78];
            }
            case 10: {
                return par1.func_176740_k().func_176720_b() ? array[79] : array[95];
            }
            case 11: {
                return array[49];
            }
            case 12: {
                return array[50];
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture(IBlockState state) {
        return this.getTextureFromState(state, EnumFacing.SOUTH);
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return this.func_176203_a(stack.func_77960_j());
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 1));
        items.add((Object)new ItemStack((Block)this, 1, 2));
        items.add((Object)new ItemStack((Block)this, 1, 3));
        items.add((Object)new ItemStack((Block)this, 1, 7));
        items.add((Object)new ItemStack((Block)this, 1, 8));
        items.add((Object)new ItemStack((Block)this, 1, 9));
        items.add((Object)new ItemStack((Block)this, 1, 10));
        items.add((Object)new ItemStack((Block)this, 1, 11));
        items.add((Object)new ItemStack((Block)this, 1, 12));
    }

    @Override
    public List<IBlockState> getValidStates() {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)ore, (Comparable)Boolean.valueOf(true));
        states.add(state.func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)ore, (Comparable)Boolean.valueOf(true)));
        states.add(state.func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)ore, (Comparable)Boolean.valueOf(true)));
        states.add(state.func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)ore, (Comparable)Boolean.valueOf(true)));
        states.add(state.func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)ore, (Comparable)Boolean.valueOf(true)));
        states.add(state.func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(7)).func_177226_a((IProperty)ore, (Comparable)Boolean.valueOf(false)));
        states.add(state.func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(8)).func_177226_a((IProperty)ore, (Comparable)Boolean.valueOf(false)));
        states.add(state.func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(9)).func_177226_a((IProperty)ore, (Comparable)Boolean.valueOf(false)));
        states.add(state.func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(10)).func_177226_a((IProperty)ore, (Comparable)Boolean.valueOf(false)));
        states.add(state.func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(11)).func_177226_a((IProperty)ore, (Comparable)Boolean.valueOf(false)));
        states.add(state.func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(12)).func_177226_a((IProperty)ore, (Comparable)Boolean.valueOf(false)));
        return states;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainerIC2((Block)this, new IProperty[]{metadata, ore});
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (this.func_176201_c(state) == 2) {
            return true;
        }
        return super.canSilkHarvest(world, pos, state, player);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int meta = this.func_176201_c(state);
        if (meta == 2) {
            int j = IC2.random.nextInt(fortune + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(StackUtil.copyWithSize(Ic2Items.uraniumDrop, 1 + j));
            return list;
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public void onLoad() {
        Ic2Items.copperOre = new ItemStack((Block)this, 1, 0);
        Ic2Items.tinOre = new ItemStack((Block)this, 1, 1);
        Ic2Items.uraniumOre = new ItemStack((Block)this, 1, 2);
        Ic2Items.silverOre = new ItemStack((Block)this, 1, 3);
        Ic2Items.copperBlock = new ItemStack((Block)this, 1, 7);
        Ic2Items.tinBlock = new ItemStack((Block)this, 1, 8);
        Ic2Items.bronzeBlock = new ItemStack((Block)this, 1, 9);
        Ic2Items.uraniumBlock = new ItemStack((Block)this, 1, 10);
        Ic2Items.silverBlock = new ItemStack((Block)this, 1, 11);
        Ic2Items.charcoalBlock = new ItemStack((Block)this, 1, 12);
        Ic2States.copperOre = this.func_176203_a(0);
        Ic2States.tinOre = this.func_176203_a(1);
        Ic2States.uraniumOre = this.func_176203_a(2);
        Ic2States.silverOre = this.func_176203_a(3);
        Ic2States.copperBlock = this.func_176203_a(7);
        Ic2States.tinBlock = this.func_176203_a(8);
        Ic2States.bronzeBlock = this.func_176203_a(9);
        Ic2States.uraniumBlock = this.func_176203_a(10);
        Ic2States.silverBlock = this.func_176203_a(11);
        Ic2States.charcoalBlock = this.func_176203_a(12);
    }

    @Override
    public List<IBlockState> getValidStates(IBlockState defaultState) {
        this.func_180632_j(defaultState.func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)ore, (Comparable)Boolean.valueOf(true)));
        return this.getValidStates();
    }
}

