/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.resources;

import ic2.core.IC2;
import ic2.core.platform.lang.ILocaleBlock;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IBlockTextureModifier;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.obj.IBlockStateLoader;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRubberWood
extends Block
implements IBlockTextureModifier,
IBlockStateLoader,
IBootable,
ILocaleBlock {
    public static PropertyDirection resinFacing = PropertyDirection.func_177713_a((String)"resinfacing", Arrays.asList(EnumFacing.field_176754_o));
    public static PropertyBool resin = PropertyBool.func_177716_a((String)"resin");
    public static PropertyBool collectable = PropertyBool.func_177716_a((String)"collectable");
    static PropertyEnum<BlockLog.EnumAxis> axis = BlockLog.field_176299_a;

    public BlockRubberWood() {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(1.0f);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176223_P().func_177226_a(axis, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)resin, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)collectable, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)resinFacing, (Comparable)EnumFacing.NORTH));
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public void onLoad() {
        Ic2Items.rubberWood = new ItemStack((Block)this);
        Ic2States.rubberWood = this.func_176223_P();
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Deprecated
    protected boolean func_149700_E() {
        return false;
    }

    @Override
    public LocaleComp getName() {
        return Ic2BlockLang.rubberLog;
    }

    public String func_149739_a() {
        return this.getName().getUnlocalized();
    }

    public String func_149732_F() {
        return this.getName().getLocalized();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (meta == 1 || meta == 2) {
            return this.func_176203_a(meta).func_177226_a((IProperty)resinFacing, (Comparable)EnumFacing.field_176754_o[MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3].func_176734_d());
        }
        return this.func_176203_a(0).func_177226_a(axis, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k()));
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        int i = 4;
        int j = i + 1;
        if (worldIn.func_175707_a(pos.func_177982_a(-j, -j, -j), pos.func_177982_a(j, j, j))) {
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-i, -i, -i), (BlockPos)pos.func_177982_a(i, i, i))) {
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                if (!iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, blockpos)) continue;
                iblockstate.func_177230_c().beginLeavesDecay(iblockstate, worldIn, blockpos);
            }
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Block)this));
        for (int i = 0; i < 1 + fortune; ++i) {
            if (RANDOM.nextInt(6) != 0) continue;
            list.add(Ic2Items.stickyResin.func_77946_l());
        }
        return list;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        IBlockState realState = worldIn.func_180495_p(pos);
        if (realState.func_177230_c() != this || !((Boolean)realState.func_177229_b((IProperty)resin)).booleanValue() || ((Boolean)realState.func_177229_b((IProperty)collectable)).booleanValue()) {
            return;
        }
        if (rand.nextInt(200) == 0) {
            worldIn.func_175656_a(pos, realState.func_177226_a((IProperty)collectable, (Comparable)Boolean.valueOf(true)));
            IC2.network.get().announceBlockUpdate(worldIn, pos);
        } else {
            worldIn.func_175684_a(pos, realState.func_177230_c(), this.func_149738_a(worldIn));
        }
    }

    public boolean func_149698_L() {
        return false;
    }

    public int func_149738_a(World worldIn) {
        return 100;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        boolean hasResin = (Boolean)state.func_177229_b((IProperty)resin);
        if (hasResin) {
            return state.func_177226_a((IProperty)resinFacing, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)resinFacing)));
        }
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((BlockLog.EnumAxis)state.func_177229_b(axis)) {
                    case X: {
                        return state.func_177226_a(axis, (Comparable)BlockLog.EnumAxis.Z);
                    }
                    case Z: {
                        return state.func_177226_a(axis, (Comparable)BlockLog.EnumAxis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox(IBlockState state) {
        return field_185505_j;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureFromState(IBlockState state, EnumFacing par1) {
        EnumFacing facing;
        BlockLog.EnumAxis blockAxis = (BlockLog.EnumAxis)state.func_177229_b(axis);
        if (blockAxis != BlockLog.EnumAxis.Y) {
            if (BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)par1.func_176740_k()) == blockAxis) {
                return Ic2Icons.getTextures("b0")[47];
            }
            return Ic2Icons.getTextures("b0")[44];
        }
        if (par1.func_176740_k().func_176720_b()) {
            return Ic2Icons.getTextures("b0")[47];
        }
        boolean hasResin = (Boolean)state.func_177229_b((IProperty)resin);
        if (hasResin && (facing = (EnumFacing)state.func_177229_b((IProperty)resinFacing)) == par1) {
            return (Boolean)state.func_177229_b((IProperty)collectable) != false ? Ic2Icons.getTextures("b0")[45] : Ic2Icons.getTextures("b0")[46];
        }
        return Ic2Icons.getTextures("b0")[44];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture(IBlockState state) {
        return Ic2Icons.getTextures("b0")[44];
    }

    @Override
    public List<IBlockState> getValidStates() {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        IBlockState state = this.func_176223_P();
        states.add(state);
        states.add(state.func_177226_a((IProperty)resin, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)collectable, (Comparable)Boolean.valueOf(false)));
        states.add(state.func_177226_a((IProperty)resin, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)collectable, (Comparable)Boolean.valueOf(true)));
        states.add(state.func_177226_a((IProperty)resin, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)collectable, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)resinFacing, (Comparable)EnumFacing.SOUTH));
        states.add(state.func_177226_a((IProperty)resin, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)collectable, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)resinFacing, (Comparable)EnumFacing.SOUTH));
        states.add(state.func_177226_a((IProperty)resin, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)collectable, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)resinFacing, (Comparable)EnumFacing.WEST));
        states.add(state.func_177226_a((IProperty)resin, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)collectable, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)resinFacing, (Comparable)EnumFacing.WEST));
        states.add(state.func_177226_a((IProperty)resin, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)collectable, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)resinFacing, (Comparable)EnumFacing.EAST));
        states.add(state.func_177226_a((IProperty)resin, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)collectable, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)resinFacing, (Comparable)EnumFacing.EAST));
        states.add(state.func_177226_a(axis, (Comparable)BlockLog.EnumAxis.X));
        states.add(state.func_177226_a(axis, (Comparable)BlockLog.EnumAxis.Z));
        return states;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainerIC2((Block)this, new IProperty[]{resinFacing, resin, collectable, axis});
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        boolean hasResin = (Boolean)state.func_177229_b((IProperty)resin);
        BlockLog.EnumAxis log = (BlockLog.EnumAxis)state.func_177229_b(axis);
        if (!hasResin) {
            if (log == BlockLog.EnumAxis.Y) {
                return 0;
            }
            if (log == BlockLog.EnumAxis.X) {
                return 9;
            }
            return 10;
        }
        return 1 + (((EnumFacing)state.func_177229_b((IProperty)resinFacing)).func_176745_a() - 2) * 2 + ((Boolean)state.func_177229_b((IProperty)collectable) != false ? 1 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 0) {
            return this.func_176223_P();
        }
        if (meta == 9) {
            return this.func_176223_P().func_177226_a(axis, (Comparable)BlockLog.EnumAxis.X);
        }
        if (meta == 10) {
            return this.func_176223_P().func_177226_a(axis, (Comparable)BlockLog.EnumAxis.Z);
        }
        EnumFacing facing = EnumFacing.func_176731_b((int)((meta - 1) / 2));
        boolean harvestable = (meta - 1) % 2 == 1;
        return this.func_176223_P().func_177226_a((IProperty)resin, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)collectable, (Comparable)Boolean.valueOf(harvestable)).func_177226_a((IProperty)resinFacing, (Comparable)facing);
    }

    @Override
    public boolean hasTextureRotation(IBlockState state, EnumFacing side) {
        BlockLog.EnumAxis enumAxis = (BlockLog.EnumAxis)state.func_177229_b(axis);
        if (enumAxis == BlockLog.EnumAxis.Z) {
            return side == EnumFacing.EAST || side == EnumFacing.WEST;
        }
        return enumAxis == BlockLog.EnumAxis.X;
    }

    @Override
    public int getTextureRotation(IBlockState state, EnumFacing side) {
        BlockLog.EnumAxis enumAxis = (BlockLog.EnumAxis)state.func_177229_b(axis);
        if (enumAxis == BlockLog.EnumAxis.Z) {
            return side == EnumFacing.EAST || side == EnumFacing.WEST ? 45 : 0;
        }
        if (enumAxis == BlockLog.EnumAxis.X) {
            return 90;
        }
        return 0;
    }

    @Override
    public boolean hasCustomTextureUV(IBlockState state, EnumFacing side) {
        return false;
    }

    @Override
    public float[] getCustomTextureUV(IBlockState state, EnumFacing side) {
        return null;
    }

    @Override
    public List<IBlockState> getValidStates(IBlockState defaultState) {
        this.func_180632_j(defaultState.func_177226_a(axis, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)resin, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)collectable, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)resinFacing, (Comparable)EnumFacing.NORTH));
        return this.getValidStates();
    }
}

