/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy.render;

import ic2.api.classic.energy.render.IRenderPath;
import ic2.api.classic.energy.render.IRenderValidator;
import ic2.core.energy.render.PathComponent;
import ic2.core.energy.render.RenderEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;

public class RenderPath
implements Iterable<RenderEntry>,
IRenderPath {
    public static int counter = 0;
    Map<BlockPos, PathComponent> componentsMap = new HashMap<BlockPos, PathComponent>();
    List<PathComponent> components = new ArrayList<PathComponent>();
    List<RenderEntry> tickList = new ArrayList<RenderEntry>();
    IRenderValidator validator;
    EntityPlayer player;
    boolean started = false;
    int targets = 0;

    public RenderPath(EntityPlayer thePlayer, IRenderValidator valid, Tuple<BlockPos, Tuple<Map<BlockPos, List<BlockPos>>, Map<BlockPos, Double>>> info) {
        this.player = thePlayer;
        this.validator = valid;
        Map mapping = (Map)((Tuple)info.func_76340_b()).func_76341_a();
        Map loss = (Map)((Tuple)info.func_76340_b()).func_76340_b();
        LinkedList<PathComponent> todoList = new LinkedList<PathComponent>();
        todoList.add(new PathComponent((BlockPos)info.func_76341_a()));
        ++counter;
        while (todoList.size() > 0) {
            PathComponent check = (PathComponent)todoList.remove();
            BlockPos pos = check.getPosition();
            if (loss.containsKey(pos)) {
                check.setLoss((Double)loss.get(pos));
            } else {
                check.setLoss(0.0);
            }
            this.components.add(check);
            this.componentsMap.put(pos, check);
            List targetList = (List)mapping.get(pos);
            if (targetList == null || targetList.isEmpty()) {
                ++this.targets;
                continue;
            }
            for (BlockPos next : targetList) {
                PathComponent comp = new PathComponent(next);
                comp.setPrev(check);
                check.addNext(comp);
                todoList.add(comp);
            }
            ++counter;
        }
        counter = 0;
    }

    public void clear() {
        for (PathComponent comp : this.components) {
            comp.clear();
        }
        for (RenderEntry entry : this.tickList) {
            entry.invalidate();
        }
        this.tickList.clear();
        this.components.clear();
        this.componentsMap.clear();
        this.targets = 0;
        this.validator = null;
    }

    public int getTargets() {
        return this.targets;
    }

    public void onTick() {
        if (this.targets <= 0 || this.components.size() <= 0) {
            return;
        }
        if (this.tickList.isEmpty()) {
            if (!this.started) {
                this.started = true;
                PathComponent start = this.components.get(0);
                if (!start.isEnd()) {
                    for (PathComponent next : start.getNext()) {
                        RenderEntry tickEntry = new RenderEntry(start);
                        tickEntry.setSpeed(this.validator.getFlowSpeed());
                        tickEntry.setNext(next);
                        this.tickList.add(tickEntry);
                    }
                }
            }
            return;
        }
        for (int i = 0; i < this.tickList.size(); ++i) {
            RenderEntry entry = this.tickList.get(i);
            entry.onTick();
            if (!entry.hasReached()) continue;
            PathComponent current = entry.getComponent();
            if (current == null || current.isEnd()) {
                this.tickList.remove(i--);
                continue;
            }
            boolean first = true;
            for (PathComponent next : current.getNext()) {
                if (first) {
                    first = false;
                    entry.setNext(next);
                    continue;
                }
                RenderEntry tickEntry = entry.copy();
                tickEntry.setNext(next);
                this.tickList.add(tickEntry);
            }
        }
        if (this.tickList.isEmpty()) {
            this.validator.onRenderFinished(this.player, this);
        }
    }

    public boolean hasWork() {
        return this.tickList.size() > 0;
    }

    @Override
    public void resetPaths() {
        this.tickList.clear();
        PathComponent start = this.components.get(0);
        if (!start.isEnd()) {
            for (PathComponent next : start.getNext()) {
                RenderEntry tickEntry = new RenderEntry(start);
                tickEntry.setSpeed(this.validator.getFlowSpeed());
                tickEntry.setNext(next);
                this.tickList.add(tickEntry);
            }
        }
    }

    @Override
    public BlockPos getStartingPos() {
        return this.components.get(0).getPosition();
    }

    @Override
    public Iterator<RenderEntry> iterator() {
        return this.tickList.iterator();
    }
}

