/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.electric;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.item.ElectricItem;
import ic2.core.item.armor.base.ItemIC2AdvArmorBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ItemArmorElectricPack
extends ItemIC2AdvArmorBase
implements IDamagelessElectricItem {
    String texture;
    int maxEnergy;
    int tier;
    int transferlimit;
    EnumRarity rare;

    public ItemArmorElectricPack(int index, EntityEquipmentSlot slot, String tex, int max, int lvl, int limit) {
        super(index, slot);
        this.func_77656_e(0);
        this.texture = tex;
        this.maxEnergy = max;
        this.tier = lvl;
        this.transferlimit = limit;
        this.rare = EnumRarity.COMMON;
    }

    public ItemArmorElectricPack(int index, String tex, int max, int lvl, int limit) {
        super(index, EntityEquipmentSlot.CHEST);
        this.func_77656_e(0);
        this.texture = tex;
        this.maxEnergy = max;
        this.tier = lvl;
        this.transferlimit = limit;
        this.rare = EnumRarity.COMMON;
    }

    public ItemArmorElectricPack setRarity(EnumRarity newValue) {
        this.rare = newValue;
        return this;
    }

    @Override
    public String getTexture() {
        return this.texture;
    }

    @Override
    public ItemStack getRepairItem() {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return this.maxEnergy;
    }

    @Override
    public int getTier(ItemStack stack) {
        return this.tier;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return this.transferlimit;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rare;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this);
        ItemStack full = new ItemStack((Item)this);
        ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
        ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
        subItems.add((Object)empty);
        subItems.add((Object)full);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }
}

