/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.base;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import ic2.core.util.obj.ToolTipType;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemIC2
extends Item
implements IStaticTexturedItem {
    public LocaleComp name = Ic2Lang.nullKey;

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        EnumMap<ToolTipType, List<String>> dataMap = new EnumMap<ToolTipType, List<String>>(ToolTipType.class);
        dataMap.put(ToolTipType.Ctrl, new LinkedList());
        dataMap.put(ToolTipType.Shift, new LinkedList());
        dataMap.put(ToolTipType.Alt, new LinkedList());
        this.onSortedItemToolTip(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, flagIn.func_194127_a(), tooltip, dataMap);
        for (ToolTipType type : new ToolTipType[]{ToolTipType.Alt, ToolTipType.Shift, ToolTipType.Ctrl}) {
            List text = (List)dataMap.get((Object)type);
            if (text.size() <= 0) continue;
            if (type.isKeyDown()) {
                text.add("");
                tooltip.addAll(1, text);
                continue;
            }
            tooltip.add(1, type.getTypeInfo());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return Ic2Icons.getTextures(this.getSheet(meta))[this.getTextureEntry(meta)];
    }

    public String getSheet(int meta) {
        return "i1";
    }

    public abstract int getTextureEntry(int var1);

    public LocaleComp getLangComponent() {
        return this.name;
    }

    public LocaleComp getLangComponent(ItemStack stack) {
        return this.getLangComponent();
    }

    public Item setUnlocalizedName(LocaleComp component) {
        this.name = component;
        return super.func_77655_b(component.getUnlocalized());
    }

    public Item func_77655_b(String unlocalizedName) {
        this.name = new LangComponentHolder.LocaleItemComp("item." + unlocalizedName);
        return super.func_77655_b(unlocalizedName);
    }

    public String func_77658_a() {
        return this.getLangComponent().getUnlocalized();
    }

    public String func_77667_c(ItemStack stack) {
        return this.getLangComponent(stack).getUnlocalized();
    }

    public String func_77657_g(ItemStack stack) {
        return this.getLangComponent(stack).getLocalized();
    }

    public String func_77653_i(ItemStack stack) {
        return this.getLangComponent(stack).getLocalized();
    }

    public static RayTraceResult rayTrace(World worldIn, EntityLivingBase playerIn, boolean useLiquids, double maxDistance) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * maxDistance, (double)f5 * maxDistance, (double)f7 * maxDistance);
        return worldIn.func_147447_a(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }

    public static RayTraceResult rayTraceEntities(World worldIn, EntityLivingBase playerIn, boolean useLiquids, double maxDistane) {
        return ItemIC2.rayTraceEntities(worldIn, playerIn, maxDistane);
    }

    public static RayTraceResult rayTraceEntities(World worldIn, EntityLivingBase playerIn, double maxDistance) {
        double d1;
        Vec3d vec3d = new Vec3d(playerIn.field_70165_t, playerIn.field_70163_u + (double)playerIn.func_70047_e(), playerIn.field_70161_v);
        Vec3d vec3d1 = playerIn.func_70040_Z();
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * maxDistance, vec3d1.field_72448_b * maxDistance, vec3d1.field_72449_c * maxDistance);
        Entity pointedEntity = null;
        Vec3d vec3d3 = null;
        float f = 1.0f;
        List list = worldIn.func_175674_a((Entity)playerIn, playerIn.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * maxDistance, vec3d1.field_72448_b * maxDistance, vec3d1.field_72449_c * maxDistance).func_186662_g(1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                return p_apply_1_ != null && p_apply_1_.func_70067_L() && (p_apply_1_ instanceof EntityLivingBase || p_apply_1_ instanceof MultiPartEntityPart || p_apply_1_ instanceof EntityEnderCrystal);
            }
        }));
        double d2 = d1 = maxDistance;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            RayTraceResult raytraceresult = axisalignedbb.func_72327_a(vec3d, vec3d2);
            if (axisalignedbb.func_72318_a(vec3d)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                vec3d3 = raytraceresult == null ? vec3d : raytraceresult.field_72307_f;
                d2 = 0.0;
                continue;
            }
            if (raytraceresult == null || !((d3 = vec3d.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
            if (entity1.func_184208_bv() == playerIn.func_184208_bv() && !playerIn.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                vec3d3 = raytraceresult.field_72307_f;
                continue;
            }
            pointedEntity = entity1;
            vec3d3 = raytraceresult.field_72307_f;
            d2 = d3;
        }
        if (pointedEntity != null) {
            return new RayTraceResult(pointedEntity, vec3d3);
        }
        return null;
    }
}

