/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.machine;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.tile.IMachine;
import ic2.core.Direction;
import ic2.core.item.upgrades.subtypes.machine.BaseFluidFilteredUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.FluidHelper;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FilteredBasicFluidExportUpgrade
extends BaseFluidFilteredUpgrade {
    @Override
    public boolean needsTick() {
        return true;
    }

    @Override
    public void onTick(ItemStack upgrade, IMachine machine) {
        this.sendFluids(upgrade, machine);
    }

    @Override
    public void onProcessFinished(ItemStack upgrade, IMachine machine) {
        this.sendFluids(upgrade, machine);
    }

    public void sendFluids(ItemStack upgrade, IMachine machine) {
        Direction dir = this.getDirection(upgrade);
        if (dir != null) {
            IFluidHandler internalTank = this.getInternalTank((TileEntity)machine, dir.toFacing());
            if (internalTank == null) {
                return;
            }
            TileEntity tile = dir.applyToTileEntity((TileEntity)machine);
            if (tile == null) {
                return;
            }
            IFluidHandler target = this.getTank(upgrade, tile, dir.getInverse().toFacing());
            if (target == null) {
                return;
            }
            Tuple<Boolean, List<FluidStack>> allowed = this.getFluids(upgrade);
            if (allowed == null) {
                return;
            }
            int limit = Math.min(90, 10 * upgrade.func_190916_E());
            IFluidTankProperties[] props = internalTank.getTankProperties();
            for (int i = 0; i < props.length && limit > 0; ++i) {
                int added;
                FluidStack toFill;
                FluidStack fluid = props[i].getContents();
                if (fluid == null || !this.isValidFluid(allowed, fluid) || (toFill = internalTank.drain(FluidHelper.copyWithSize(fluid, Math.min(limit, fluid.amount)), false)) == null || toFill.amount <= 0 || (added = target.fill(toFill, true)) <= 0) continue;
                internalTank.drain(FluidHelper.copyWithSize(fluid, added), true);
                limit -= added;
            }
        }
    }

    @Override
    public IMachineUpgradeItem.UpgradeType getType() {
        return IMachineUpgradeItem.UpgradeType.ImportExport;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        return Ic2Icons.getTextures("i0")[158];
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.basicFilteredFluidExportUpgrade;
    }

    @Override
    public boolean usesOwner() {
        return true;
    }

    @Override
    public boolean usesDirection() {
        return true;
    }
}

