/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.command;

import cofh.cofhworld.init.WorldHandler;
import cofh.cofhworld.world.IFeatureGenerator;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.command.CommandTreeBase;

public class CommandCoFHWorld
extends CommandTreeBase {
    public String func_71517_b() {
        return "cofhworld";
    }

    public int func_82362_a() {
        return -1;
    }

    public String func_71518_a(ICommandSender sender) {
        return "cofhworld.usage";
    }

    public CommandCoFHWorld() {
        this.addSubcommand((ICommand)new CommandReload());
        this.addSubcommand((ICommand)new CommandList());
        this.addSubcommand((ICommand)new CommandVersion());
    }

    public static class CommandList
    extends CommandBase {
        public String func_71517_b() {
            return "list";
        }

        public int func_82362_a() {
            return 1;
        }

        public String func_71518_a(ICommandSender sender) {
            return "cofhworld.list.usage";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            int pageSize = 8;
            List<IFeatureGenerator> generators = WorldHandler.getFeatures();
            int maxPages = (generators.size() - 1) / 8;
            int page = args.length == 0 ? 0 : CommandBase.func_175764_a((String)args[0], (int)1, (int)(maxPages + 1)) - 1;
            TextComponentTranslation component = new TextComponentTranslation("cofhworld.list", new Object[]{page + 1, maxPages + 1});
            component.func_150256_b().func_150238_a(TextFormatting.GOLD);
            sender.func_145747_a((ITextComponent)component);
            if (generators.size() == 0) {
                return;
            }
            StringBuilder b = new StringBuilder();
            int maxIndex = Math.min((page + 1) * 8, generators.size());
            for (int i = page * 8; i < maxIndex; ++i) {
                b.append("* ").append(generators.get(i).getFeatureName()).append('\n');
            }
            b.deleteCharAt(b.length() - 1);
            sender.func_145747_a((ITextComponent)new TextComponentString(b.toString()));
        }
    }

    public static class CommandReload
    extends CommandBase {
        public String func_71517_b() {
            return "reload";
        }

        public int func_82362_a() {
            return 4;
        }

        public String func_71518_a(ICommandSender sender) {
            return "cofhworld.reload.usage";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (WorldHandler.reloadConfig()) {
                CommandReload.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cofhworld.reload.successful", (Object[])new Object[0]);
            } else {
                CommandReload.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cofhworld.reload.failed", (Object[])new Object[0]);
            }
        }
    }

    public static class CommandVersion
    extends CommandBase {
        public String func_71517_b() {
            return "version";
        }

        public int func_82362_a() {
            return -1;
        }

        public String func_71518_a(ICommandSender sender) {
            return "cofhworld.version.usage";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            sender.func_145747_a((ITextComponent)new TextComponentString("1.3.0"));
        }
    }
}

