/*
 * Decompiled with CFR 0.152.
 */
package mnm.plugins.meem;

import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;

@Plugin(id="meem", name="MeeM", authors={"killjoy1221"}, description="Basic memory commands.", version="1.0", url="https://github.com/killjoy1221/MeeM")
public class Meem {
    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        Sponge.getCommandManager().register((Object)this, (CommandCallable)CommandSpec.builder().permission("meem.mem").description((Text)Text.of((String)"Shows memory usage of the server.")).executor((src, args) -> {
            long total = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory();
            long max = Runtime.getRuntime().maxMemory();
            long used = total - free;
            double perc = (double)free / (double)total;
            TextColor color = perc < 0.2 ? TextColors.RED : (perc < 0.4 ? TextColors.YELLOW : TextColors.GREEN);
            String ftotal = Meem.formatBytes(total);
            String fmax = Meem.formatBytes(max);
            String fused = Meem.formatBytes(used);
            String fperc = String.format(" (%.1f%% free) ", perc * 100.0);
            src.sendMessage(Text.of((Object[])new Object[]{fused, "/", ftotal, color, fperc, TextColors.RESET, fmax, " max"}));
            return CommandResult.success();
        }).build(), new String[]{"mem"});
        Sponge.getCommandManager().register((Object)this, (CommandCallable)CommandSpec.builder().permission("meem.gc").description(Text.of((Object[])new Object[]{"Runs garbage collection to free up memory. ", TextColors.RED, TextStyles.BOLD, "This may cause a lag spike."})).executor((src, args) -> {
            long free1 = Runtime.getRuntime().freeMemory();
            System.gc();
            long free2 = Runtime.getRuntime().freeMemory();
            String freed = Meem.formatBytes(free2 - free1);
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.GRAY, "GC has completed. Freed ", freed}));
            return CommandResult.success();
        }).build(), new String[]{"gc"});
    }

    private static String formatBytes(long bytes) {
        int unit = 1024;
        if (Math.abs(bytes) < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "kMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }
}

