/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.blocks.tileentity;

import ic2.core.block.base.tile.TileEntityGeneratorBase;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.util.math.Box2D;
import ic2.core.util.math.Vec2i;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import trinsdar.ic2c_extras.blocks.container.ContainerThermoElectricGenerator;
import trinsdar.ic2c_extras.items.ItemRTG;
import trinsdar.ic2c_extras.util.Registry;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasResourceLocations;

public class TileEntityThermoElectricGenerator
extends TileEntityGeneratorBase {
    public static BasicItemFilter filter = new BasicItemFilter(new ItemStack((Item)Registry.plutoniumRTG));
    int counter = 0;

    public TileEntityThermoElectricGenerator() {
        super(6);
        this.tier = 1;
        this.maxStorage = 20000;
    }

    public BasicItemFilter getFilter() {
        return filter;
    }

    public double getOfferedEnergy() {
        return this.getProduction() == 0 ? (double)Math.min(this.storage, 32) : (double)Math.min(this.storage, this.getProduction());
    }

    public int getProduction() {
        int count = -1;
        for (int i = 0; i < 6; ++i) {
            if (!((ItemStack)this.inventory.get(i)).func_77969_a(new ItemStack((Item)Registry.plutoniumRTG))) continue;
            ++count;
        }
        if (count == -1) {
            return 0;
        }
        this.production = (int)Math.pow(2.0, count);
        return this.production;
    }

    public int getOutput() {
        return this.getProduction();
    }

    public boolean isConverting() {
        return this.storage + this.getProduction() <= this.maxStorage;
    }

    public int getMaxSendingEnergy() {
        return this.getProduction() + 1;
    }

    public void func_73660_a() {
        int oldEnergy = this.storage;
        boolean active = this.gainEnergy();
        if (this.storage > 0 && this.storage > this.maxStorage) {
            this.storage = this.maxStorage;
        }
        if (!this.delayActiveUpdate()) {
            this.setActive(active);
        } else {
            if (this.ticksSinceLastActiveUpdate % this.getDelay() == 0) {
                this.setActive(this.activityMeter > 0);
                this.activityMeter = 0;
            }
            this.activityMeter = active ? ++this.activityMeter : --this.activityMeter;
            ++this.ticksSinceLastActiveUpdate;
        }
        if (oldEnergy != this.storage) {
            this.getNetwork().updateTileGuiField((TileEntity)this, "storage");
        }
        this.updateComparators();
    }

    private boolean isInventoryEmpty() {
        int count = 0;
        for (int i = 0; i < 6; ++i) {
            if (!(((ItemStack)this.inventory.get(i)).func_77973_b() instanceof ItemRTG)) continue;
            ++count;
        }
        return count == 0;
    }

    public boolean gainEnergy() {
        if (this.isConverting() && !this.isInventoryEmpty()) {
            this.storage += this.getProduction();
            ++this.counter;
            if (this.counter == 20) {
                for (int i = 0; i < 6; ++i) {
                    ItemStack stack = (ItemStack)this.inventory.get(i);
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemRTG)) continue;
                    ItemRTG rtg = (ItemRTG)stack.func_77973_b();
                    int damage = rtg.getCustomDamage(stack) + 1;
                    if (damage > rtg.getMaxCustomDamage(stack)) {
                        stack.func_190918_g(1);
                        continue;
                    }
                    rtg.setCustomDamage(stack, damage);
                }
                this.counter = 0;
            }
            this.getNetwork().updateTileGuiField((TileEntity)this, "fuel");
            return true;
        }
        return false;
    }

    public ResourceLocation getTexture() {
        return Ic2cExtrasResourceLocations.thermoElectricGenerator;
    }

    public Box2D getEnergyBox() {
        return Ic2GuiComp.generatorEnergyBox;
    }

    public Vec2i getEnergyPos() {
        return Ic2GuiComp.machineChargePos;
    }

    public boolean gainFuel() {
        return false;
    }

    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerThermoElectricGenerator(entityPlayer.field_71071_by, this);
    }

    public LocaleComp getBlockName() {
        return Ic2cExtrasLang.thermoElectricGenerator;
    }

    public static class TileEntityThermoElectricGeneratorMkII
    extends TileEntityThermoElectricGenerator {
        public static BasicItemFilter filter2 = new BasicItemFilter(new ItemStack((Item)Registry.thoriumRTG));

        public TileEntityThermoElectricGeneratorMkII() {
            this.tier = 2;
            this.maxStorage = 30000;
        }

        @Override
        public BasicItemFilter getFilter() {
            return filter2;
        }

        @Override
        public LocaleComp getBlockName() {
            return Ic2cExtrasLang.thermoElectricGeneratorMkII;
        }

        @Override
        public int getProduction() {
            int count = 0;
            for (int i = 0; i < 6; ++i) {
                if (!((ItemStack)this.inventory.get(i)).func_77969_a(new ItemStack((Item)Registry.thoriumRTG))) continue;
                ++count;
            }
            if (count == 0) {
                return 0;
            }
            this.production = (int)Math.pow(2.0, count);
            return this.production;
        }
    }
}

