/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.api.network;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import jline.internal.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import omtteam.openmodularturrets.api.IBaseController;
import omtteam.openmodularturrets.api.network.INetworkTile;
import omtteam.openmodularturrets.api.network.IPowerExchangeTile;
import omtteam.openmodularturrets.handler.OMTEventHandler;

public class OMTNetwork {
    private Map<BlockPos, INetworkTile> devices = new HashMap<BlockPos, INetworkTile>();
    private World world;
    private UUID uuid;
    private String name;

    public OMTNetwork(World world) {
        this.world = world;
        this.uuid = UUID.randomUUID();
        OMTEventHandler.getInstance().registerNetwork(this);
    }

    public OMTNetwork(World world, String name) {
        this.world = world;
        this.uuid = UUID.randomUUID();
        this.name = name;
        OMTEventHandler.getInstance().registerNetwork(this);
    }

    public OMTNetwork(World world, String name, UUID uuid) {
        this.world = world;
        this.uuid = uuid;
        this.name = name;
        OMTEventHandler.getInstance().registerNetwork(this);
        this.loadFromDisk(uuid, world);
    }

    public void tick() {
        ArrayList<IPowerExchangeTile> delivering = new ArrayList<IPowerExchangeTile>();
        ArrayList<IPowerExchangeTile> requiring = new ArrayList<IPowerExchangeTile>();
        int powerRequired = 0;
        int powerToDeliver = 0;
        for (Map.Entry<BlockPos, INetworkTile> device : this.devices.entrySet()) {
            if (!this.world.func_175667_e(device.getKey()) || !(device.getValue() instanceof IPowerExchangeTile)) continue;
            if (((IPowerExchangeTile)device.getValue()).deliversEnergy()) {
                delivering.add((IPowerExchangeTile)device.getValue());
                continue;
            }
            if (!((IPowerExchangeTile)device.getValue()).requiresEnergy()) continue;
            requiring.add((IPowerExchangeTile)device.getValue());
        }
        for (IPowerExchangeTile tile : requiring) {
            powerRequired += Math.min(tile.getEnergyStorage().getMaxReceive(), tile.getEnergyStorage().getMaxEnergyStored() - tile.getEnergyStorage().getEnergyStored());
        }
        for (IPowerExchangeTile tile : delivering) {
            powerToDeliver += Math.min(powerRequired - powerToDeliver, Math.min(tile.getEnergyStorage().getMaxExtract(), tile.getEnergyStorage().getMaxEnergyStored() - tile.getEnergyStorage().getEnergyStored()));
        }
        for (IPowerExchangeTile tile : requiring) {
            tile.getEnergyStorage().receiveEnergy(powerToDeliver / requiring.size(), false);
            powerToDeliver -= powerToDeliver / requiring.size();
        }
    }

    @Nullable
    public IBaseController getController() {
        for (INetworkTile device : this.devices.values()) {
            if (!(device instanceof IBaseController)) continue;
            return (IBaseController)((Object)device);
        }
        return null;
    }

    public boolean addDevice(INetworkTile tile) {
        boolean controllerExists;
        boolean bl = controllerExists = this.getController() != null;
        if (tile instanceof IBaseController && !controllerExists) {
            this.devices.putIfAbsent(tile.getPosition(), tile);
            return true;
        }
        if (!(tile instanceof IBaseController)) {
            this.devices.putIfAbsent(tile.getPosition(), tile);
            return true;
        }
        return false;
    }

    public boolean removeDevice(INetworkTile tile) {
        return this.devices.remove(tile.getPosition()) != null;
    }

    @Nullable
    public INetworkTile getConnectedDevice(BlockPos pos) {
        return this.world.func_175667_e(pos) ? this.devices.get(pos) : null;
    }

    public Collection<INetworkTile> getAllDevices() {
        return this.devices.values();
    }

    public World getWorld() {
        return this.world;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private boolean isSplitted() {
        HashMap<BlockPos, INetworkTile> tempmap = new HashMap<BlockPos, INetworkTile>();
        this.recursiveSearch((BlockPos)this.devices.keySet().toArray()[0], null, tempmap);
        return tempmap.keySet().equals(this.devices.keySet());
    }

    private void recursiveSearch(BlockPos pos, @Nullable EnumFacing from, HashMap<BlockPos, INetworkTile> tempmap) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity te = this.world.func_175625_s(pos.func_177972_a(facing));
            if (facing.equals((Object)from) || !(te instanceof INetworkTile & te != null)) continue;
            tempmap.put(pos.func_177972_a(facing), (INetworkTile)te);
            this.recursiveSearch(pos.func_177972_a(facing), facing.func_176734_d(), tempmap);
        }
    }

    public void splitNetwork() {
        if (this.isSplitted()) {
            for (INetworkTile tile : this.devices.values()) {
                tile.setNetwork(null);
            }
        }
    }

    public void mergeNetwork(OMTNetwork network) {
        for (INetworkTile tile : network.getAllDevices()) {
            this.devices.putIfAbsent(tile.getPosition(), tile);
            tile.setNetwork(this);
        }
        network.destroy();
    }

    public NBTTagCompound getAsNBTTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_186854_a("uuid", this.uuid);
        tag.func_74778_a("name", this.name);
        return tag;
    }

    public UUID getUuidFromTagCompound(NBTTagCompound tag) {
        return tag.func_186857_a("uuid");
    }

    private void destroy() {
        OMTEventHandler.getInstance().removeNetwork(this);
        this.devices = null;
        this.world = null;
    }

    public void saveToDisk() {
        File saveRoot = DimensionManager.getCurrentSaveRootDirectory();
        if (saveRoot != null) {
            Path path = Paths.get(saveRoot.toString() + "/omt/", new String[0]);
            Path fullpath = Paths.get(saveRoot.toString() + "/omt/network-" + this.getUuid().toString() + ".sav", new String[0]);
            try {
                if (Files.notExists(path, new LinkOption[0]) && !path.toFile().mkdir()) {
                    throw new Exception("Failed to create dir");
                }
                FileOutputStream saveFile = new FileOutputStream(fullpath.toFile());
                ObjectOutputStream save = new ObjectOutputStream(saveFile);
                save.writeObject(this.devices.keySet());
                save.close();
                saveFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Files.deleteIfExists(fullpath);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void loadFromDisk(UUID uuid, World world) {
        try {
            HashSet tempList = new HashSet();
            Path fullpath = Paths.get(DimensionManager.getCurrentSaveRootDirectory().toString() + "/omt/network- " + uuid.toString() + ").sav", new String[0]);
            FileInputStream saveFile = new FileInputStream(fullpath.toFile());
            ObjectInputStream save = new ObjectInputStream(saveFile);
            Object object = save.readObject();
            if (object instanceof Set) {
                tempList = (HashSet)object;
            }
            save.close();
            saveFile.close();
            for (BlockPos pos : tempList) {
                this.devices.put(pos, (INetworkTile)world.func_175625_s(pos));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

