/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.registries.IForgeRegistry;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.api.network.OMTNetwork;
import omtteam.openmodularturrets.entity.projectiles.damagesources.AbstractOMTDamageSource;
import omtteam.openmodularturrets.handler.OMTConfigHandler;
import omtteam.openmodularturrets.init.ModBlocks;
import omtteam.openmodularturrets.init.ModItems;
import omtteam.openmodularturrets.init.ModSounds;
import omtteam.openmodularturrets.util.OMTFakePlayer;
import omtteam.openmodularturrets.util.OMTUtil;

public class OMTEventHandler {
    private static OMTEventHandler instance;
    private HashMap<World, List<OMTNetwork>> networks = new HashMap();

    private OMTEventHandler() {
    }

    public static OMTEventHandler getInstance() {
        if (instance == null) {
            instance = new OMTEventHandler();
        }
        return instance;
    }

    @SubscribeEvent
    public void lootEvent(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        int fakeDrops = OMTUtil.getFakeDropsLevel(entity);
        if (entity.func_184216_O().contains("openmodularturrets:turret_hit") && !OMTConfigHandler.doTurretsKillsDropMobLoot && (fakeDrops < 0 || !OMTConfigHandler.doLootAddonsOverrideMobLootSetting) || entity.func_184216_O().contains("openmodularturrets:dont_drop_loot")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void entityHurtEvent(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        int fakeDrops = OMTUtil.getFakeDropsLevel(entity);
        if (fakeDrops >= 0) {
            FakePlayer player = OMTFakePlayer.getFakePlayer((WorldServer)event.getEntityLiving().func_130014_f_());
            player.func_184611_a(EnumHand.MAIN_HAND, OMTFakePlayer.getSword(fakeDrops));
            entity.func_130011_c((Entity)player);
        }
    }

    @SubscribeEvent
    public void entityAttackedEvent(LivingAttackEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        int fakeDrops = OMTUtil.getFakeDropsLevel(entity);
        if (fakeDrops >= 0) {
            FakePlayer player = OMTFakePlayer.getFakePlayer((WorldServer)event.getEntityLiving().func_130014_f_());
            player.func_184611_a(EnumHand.MAIN_HAND, OMTFakePlayer.getSword(fakeDrops));
            entity.func_130011_c((Entity)player);
        }
    }

    @SubscribeEvent
    public void entityDeathEvent(LivingDeathEvent event) {
        if (event.getSource() instanceof AbstractOMTDamageSource) {
            ((AbstractOMTDamageSource)event.getSource()).getBase().increaseKillCounter();
            if (event.getEntity() instanceof EntityPlayer) {
                ((AbstractOMTDamageSource)event.getSource()).getBase().increasePlayerKillCounter();
            }
        }
    }

    private List<OMTNetwork> getNetworkListForWorld(World world) {
        this.networks.putIfAbsent(world, new ArrayList());
        return this.networks.get(world);
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.WorldTickEvent event) {
        for (OMTNetwork network : this.getNetworkListForWorld(event.world)) {
            network.tick();
        }
    }

    @SubscribeEvent
    public void blockRegisterEvent(RegistryEvent.Register<Block> event) {
        ModBlocks.initBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public void itemRegisterEvent(RegistryEvent.Register<Item> event) {
        ModItems.init((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public void soundRegistryEvent(RegistryEvent.Register<SoundEvent> event) {
        ModSounds.init((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    @SubscribeEvent
    public void renderRegisterEvent(ModelRegistryEvent event) {
        OpenModularTurrets.proxy.initModelLoaders();
    }

    public void registerNetwork(OMTNetwork network) {
        this.getNetworkListForWorld(network.getWorld()).add(network);
    }

    public void removeNetwork(OMTNetwork network) {
        this.getNetworkListForWorld(network.getWorld()).remove(network);
    }

    @SubscribeEvent
    public void worldLoadEvent(WorldEvent.Load event) {
        try {
            HashMap tempList = new HashMap();
            Path fullpath = Paths.get(DimensionManager.getCurrentSaveRootDirectory().toString() + "/omt/networks.sav", new String[0]);
            FileInputStream saveFile = new FileInputStream(fullpath.toFile());
            ObjectInputStream save = new ObjectInputStream(saveFile);
            Object object = save.readObject();
            if (object instanceof Map) {
                tempList = (HashMap)object;
            }
            save.close();
            saveFile.close();
            for (Map.Entry entry : tempList.entrySet()) {
                WorldServer world = DimensionManager.getWorld((int)((Integer)entry.getKey()));
                for (Tuple tuple : (List)entry.getValue()) {
                    new OMTNetwork((World)world, (String)tuple.func_76340_b(), (UUID)tuple.func_76341_a());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void worldUnloadEvent(WorldEvent.Unload event) {
        HashMap list = new HashMap();
        for (Map.Entry<World, List<OMTNetwork>> entry : this.networks.entrySet()) {
            ArrayList<Tuple> tempList = new ArrayList<Tuple>();
            for (OMTNetwork network : entry.getValue()) {
                tempList.add(new Tuple((Object)network.getUuid(), (Object)network.getName()));
                network.saveToDisk();
            }
            list.put(entry.getKey().field_73011_w.getDimension(), tempList);
        }
        File saveRoot = DimensionManager.getCurrentSaveRootDirectory();
        if (saveRoot != null) {
            Path path = Paths.get(saveRoot.toString() + "/omt/", new String[0]);
            Path fullpath = Paths.get(saveRoot.toString() + "/omt/networks.sav", new String[0]);
            try {
                if (Files.notExists(path, new LinkOption[0]) && !path.toFile().mkdir()) {
                    throw new Exception("Failed to create dir");
                }
                FileOutputStream saveFile = new FileOutputStream(fullpath.toFile());
                ObjectOutputStream save = new ObjectOutputStream(saveFile);
                save.writeObject(list);
                save.close();
                saveFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Files.deleteIfExists(fullpath);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

