/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import java.util.Arrays;
import mcjty.lib.container.SlotType;
import net.minecraft.item.ItemStack;

public class SlotDefinition {
    private final SlotType type;
    private final ItemStack[] itemStacks;
    private final Class<?> itemClass;

    public SlotDefinition(SlotType type, ItemStack ... itemStacks) {
        this.type = type;
        this.itemStacks = itemStacks;
        this.itemClass = null;
    }

    public SlotDefinition(SlotType type, Class<?> itemClass) {
        this.type = type;
        this.itemStacks = new ItemStack[0];
        this.itemClass = itemClass;
    }

    public SlotType getType() {
        return this.type;
    }

    public boolean itemStackMatches(ItemStack stack) {
        for (ItemStack itemStack : this.itemStacks) {
            if (itemStack.func_77973_b() != stack.func_77973_b()) continue;
            return true;
        }
        return this.itemClass != null && this.itemClass.isInstance(stack.func_77973_b());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotDefinition that = (SlotDefinition)o;
        if (!Arrays.equals(this.itemStacks, that.itemStacks)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.itemStacks != null ? Arrays.hashCode(this.itemStacks) : 0);
        return result;
    }
}

