/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.actionlog;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.utils.ImmutableCollectors;

public class Log {
    private static Log empty = null;
    private final SortedSet<ExtendedLogEntry> content;

    public static Builder builder() {
        return new Builder();
    }

    public static synchronized Log empty() {
        if (empty == null) {
            empty = Log.builder().build();
        }
        return empty;
    }

    public Log(SortedSet<ExtendedLogEntry> content) {
        this.content = ImmutableSortedSet.copyOfSorted(content);
    }

    public SortedSet<ExtendedLogEntry> getContent() {
        return this.content;
    }

    public SortedSet<ExtendedLogEntry> getContent(UUID actor) {
        return this.content.stream().filter(e -> e.getActor().equals(actor)).collect(Collectors.toCollection(TreeSet::new));
    }

    public SortedSet<ExtendedLogEntry> getUserHistory(UUID uuid) {
        return (SortedSet)this.content.stream().filter(e -> e.getType() == LogEntry.Type.USER).filter(e -> e.getActed().isPresent() && e.getActed().get().equals(uuid)).collect(ImmutableCollectors.toSortedSet(Comparator.naturalOrder()));
    }

    public SortedSet<ExtendedLogEntry> getGroupHistory(String name) {
        return (SortedSet)this.content.stream().filter(e -> e.getType() == LogEntry.Type.GROUP).filter(e -> e.getActedName().equals(name)).collect(ImmutableCollectors.toSortedSet(Comparator.naturalOrder()));
    }

    public SortedSet<ExtendedLogEntry> getTrackHistory(String name) {
        return (SortedSet)this.content.stream().filter(e -> e.getType() == LogEntry.Type.TRACK).filter(e -> e.getActedName().equals(name)).collect(ImmutableCollectors.toSortedSet(Comparator.naturalOrder()));
    }

    public SortedSet<ExtendedLogEntry> getSearch(String query) {
        return (SortedSet)this.content.stream().filter(e -> e.matchesSearch(query)).collect(ImmutableCollectors.toSortedSet(Comparator.naturalOrder()));
    }

    public static class Builder {
        private final SortedSet<ExtendedLogEntry> content = new TreeSet<ExtendedLogEntry>();

        public Builder add(ExtendedLogEntry e) {
            this.content.add(e);
            return this;
        }

        public Log build() {
            return new Log(this.content);
        }
    }
}

