/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.actionlog;

import java.util.Optional;
import me.lucko.luckperms.api.event.log.LogBroadcastEvent;
import me.lucko.luckperms.api.event.log.LogNotifyEvent;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.commands.log.LogNotify;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.messaging.InternalMessagingService;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;

public class LogDispatcher {
    private final LuckPermsPlugin plugin;

    public LogDispatcher(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    private void broadcast(ExtendedLogEntry entry, LogNotifyEvent.Origin origin, Sender sender) {
        this.plugin.getOnlineSenders().filter(CommandPermission.LOG_NOTIFY::isAuthorized).filter(s -> {
            boolean shouldCancel = LogNotify.isIgnoring(this.plugin, s.getUuid()) || sender != null && s.getUuid().equals(sender.getUuid());
            return !this.plugin.getEventFactory().handleLogNotify(shouldCancel, entry, origin, (Sender)s);
        }).forEach(s -> Message.LOG.send((Sender)s, entry.getActorFriendlyString(), Character.toString(entry.getType().getCode()), entry.getActedFriendlyString(), entry.getAction()));
    }

    public void dispatch(ExtendedLogEntry entry, Sender sender) {
        boolean shouldCancel;
        if (!this.plugin.getEventFactory().handleLogPublish(sender.isImport(), entry)) {
            this.plugin.getStorage().logAction(entry);
        }
        if (sender.isImport()) {
            return;
        }
        Optional<InternalMessagingService> messagingService = this.plugin.getMessagingService();
        if (!sender.isImport() && messagingService.isPresent()) {
            messagingService.get().pushLog(entry);
        }
        boolean bl = shouldCancel = this.plugin.getConfiguration().get(ConfigKeys.LOG_NOTIFY) == false;
        if (!this.plugin.getEventFactory().handleLogBroadcast(shouldCancel, entry, LogBroadcastEvent.Origin.LOCAL)) {
            this.broadcast(entry, LogNotifyEvent.Origin.LOCAL, sender);
        }
    }

    public void dispatchFromApi(ExtendedLogEntry entry) {
        if (!this.plugin.getEventFactory().handleLogPublish(false, entry)) {
            try {
                this.plugin.getStorage().logAction(entry).get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.broadcastFromApi(entry);
    }

    public void broadcastFromApi(ExtendedLogEntry entry) {
        boolean shouldCancel;
        this.plugin.getMessagingService().ifPresent(extendedMessagingService -> extendedMessagingService.pushLog(entry));
        boolean bl = shouldCancel = this.plugin.getConfiguration().get(ConfigKeys.LOG_NOTIFY) == false;
        if (!this.plugin.getEventFactory().handleLogBroadcast(shouldCancel, entry, LogBroadcastEvent.Origin.LOCAL_API)) {
            this.broadcast(entry, LogNotifyEvent.Origin.LOCAL_API, null);
        }
    }

    public void dispatchFromRemote(ExtendedLogEntry entry) {
        boolean shouldCancel;
        boolean bl = shouldCancel = this.plugin.getConfiguration().get(ConfigKeys.BROADCAST_RECEIVED_LOG_ENTRIES) == false || this.plugin.getConfiguration().get(ConfigKeys.LOG_NOTIFY) == false;
        if (!this.plugin.getEventFactory().handleLogBroadcast(shouldCancel, entry, LogBroadcastEvent.Origin.REMOTE)) {
            this.broadcast(entry, LogNotifyEvent.Origin.REMOTE, null);
        }
    }
}

