/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.HeldPermission;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.common.bulkupdate.comparisons.Comparison;
import me.lucko.luckperms.common.bulkupdate.comparisons.Constraint;
import me.lucko.luckperms.common.bulkupdate.comparisons.StandardComparison;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.node.comparator.HeldPermissionComparator;
import me.lucko.luckperms.common.node.factory.NodeFactory;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.DurationFormatter;
import me.lucko.luckperms.common.utils.Iterators;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.common.utils.TextUtils;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import me.lucko.luckperms.lib.text.BuildableComponent;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;

public class SearchCommand
extends SingleCommand {
    public SearchCommand(LocaleManager locale) {
        super(CommandSpec.SEARCH.localize(locale), "Search", CommandPermission.SEARCH, Predicates.notInRange(1, 3));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        StandardComparison comparison = StandardComparison.parseComparison(args.get(0));
        if (comparison == null) {
            comparison = StandardComparison.EQUAL;
            args.add(0, "==");
        }
        Constraint query = Constraint.of(comparison, args.get(1));
        int page = ArgumentParser.parseIntOrElse(2, args, 1);
        Message.SEARCH_SEARCHING.send(sender, query);
        List matchedUsers = plugin.getStorage().getUsersWithPermission(query).join();
        List matchedGroups = plugin.getStorage().getGroupsWithPermission(query).join();
        int users = matchedUsers.size();
        int groups = matchedGroups.size();
        Message.SEARCH_RESULT.send(sender, users + groups, users, groups);
        if (!matchedUsers.isEmpty()) {
            LoadingCache uuidLookups = Caffeine.newBuilder().build(u -> {
                String s = plugin.getStorage().getPlayerName((UUID)u).join();
                if (s != null && !s.isEmpty() && !s.equals("null")) {
                    return s;
                }
                if (plugin.getConfiguration().get(ConfigKeys.USE_SERVER_UUID_CACHE).booleanValue() && (s = (String)plugin.getBootstrap().lookupUsername((UUID)u).orElse(null)) != null) {
                    return s;
                }
                return u.toString();
            });
            SearchCommand.sendResult(sender, matchedUsers, arg_0 -> ((LoadingCache)uuidLookups).get(arg_0), Message.SEARCH_SHOWING_USERS, HolderType.USER, label, page, comparison);
        }
        if (!matchedGroups.isEmpty()) {
            SearchCommand.sendResult(sender, matchedGroups, Function.identity(), Message.SEARCH_SHOWING_GROUPS, HolderType.GROUP, label, page, comparison);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return TabCompleter.create().at(0, TabCompletions.permissions(plugin)).complete(args);
    }

    private static <T extends Comparable<T>> void sendResult(Sender sender, List<HeldPermission<T>> results, Function<T, String> lookupFunction, Message headerMessage, HolderType holderType, String label, int page, Comparison comparison) {
        results = new ArrayList<HeldPermission<T>>(results);
        results.sort(HeldPermissionComparator.normal());
        int pageIndex = page - 1;
        List<List<HeldPermission<T>>> pages = Iterators.divideIterable(results, 15);
        if (pageIndex < 0 || pageIndex >= pages.size()) {
            page = 1;
            pageIndex = 0;
        }
        List<HeldPermission<T>> content = pages.get(pageIndex);
        List mappedContent = content.stream().map(hp -> Maps.immutableEntry(lookupFunction.apply(hp.getHolder()), (Object)hp)).collect(Collectors.toList());
        headerMessage.send(sender, page, pages.size(), results.size());
        for (Map.Entry ent : mappedContent) {
            String permission = "";
            if (comparison != StandardComparison.EQUAL) {
                permission = "&7 - (" + ((HeldPermission)ent.getValue()).getPermission() + ")";
            }
            String s = "&3> &b" + (String)ent.getKey() + permission + "&7 - " + (((HeldPermission)ent.getValue()).getValue() ? "&a" : "&c") + ((HeldPermission)ent.getValue()).getValue() + SearchCommand.getNodeExpiryString(((HeldPermission)ent.getValue()).asNode()) + MessageUtils.getAppendableNodeContextString(sender.getPlugin().getLocaleManager(), ((HeldPermission)ent.getValue()).asNode());
            TextComponent message = ((TextComponent.Builder)TextUtils.fromLegacy(s, '&').toBuilder().applyDeep(SearchCommand.makeFancy((String)ent.getKey(), holderType, label, (HeldPermission)ent.getValue(), sender.getPlugin()))).build();
            sender.sendMessage((Component)message);
        }
    }

    private static String getNodeExpiryString(Node node) {
        if (!node.isTemporary()) {
            return "";
        }
        return " &8(&7expires in " + DurationFormatter.LONG.formatDateDiff(node.getExpiryUnixTime()) + "&8)";
    }

    private static Consumer<BuildableComponent.Builder<?, ?>> makeFancy(String holderName, HolderType holderType, String label, HeldPermission<?> perm, LuckPermsPlugin plugin) {
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Component)TextUtils.fromLegacy(TextUtils.joinNewline("&3> " + (perm.asNode().getValue() ? "&a" : "&c") + perm.asNode().getPermission(), " ", "&7Click to remove this node from " + holderName), '&'));
        String command = "/" + label + " " + NodeFactory.nodeAsCommand(perm.asNode(), holderName, holderType, false, !plugin.getConfiguration().getContextsFile().getDefaultContexts().isEmpty());
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command);
        return component -> {
            component.hoverEvent(hoverEvent);
            component.clickEvent(clickEvent);
        };
    }
}

