/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.common.verbose.InvalidFilterException;
import me.lucko.luckperms.common.verbose.VerboseFilter;
import me.lucko.luckperms.common.verbose.VerboseListener;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import me.lucko.luckperms.lib.text.format.TextColor;

public class VerboseCommand
extends SingleCommand {
    public VerboseCommand(LocaleManager locale) {
        super(CommandSpec.VERBOSE.localize(locale), "Verbose", CommandPermission.VERBOSE, Predicates.is(0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        if (args.isEmpty()) {
            this.sendUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        String mode = args.get(0).toLowerCase();
        if (mode.equals("on") || mode.equals("true") || mode.equals("record")) {
            VerboseFilter parsedFilter;
            ArrayList<String> filters = new ArrayList<String>();
            if (args.size() != 1) {
                filters.addAll(args.subList(1, args.size()));
            }
            String filter = filters.isEmpty() ? "" : filters.stream().collect(Collectors.joining(" "));
            try {
                parsedFilter = VerboseFilter.parse(filter);
            }
            catch (InvalidFilterException e) {
                e.printStackTrace();
                Message.VERBOSE_INVALID_FILTER.send(sender, filter);
                return CommandResult.FAILURE;
            }
            boolean notify = !mode.equals("record");
            plugin.getVerboseHandler().registerListener(sender, parsedFilter, notify);
            if (notify) {
                if (!filter.equals("")) {
                    Message.VERBOSE_ON_QUERY.send(sender, filter);
                    return CommandResult.SUCCESS;
                }
                Message.VERBOSE_ON.send(sender, new Object[0]);
                return CommandResult.SUCCESS;
            }
            if (!filter.equals("")) {
                Message.VERBOSE_RECORDING_ON_QUERY.send(sender, filter);
                return CommandResult.SUCCESS;
            }
            Message.VERBOSE_RECORDING_ON.send(sender, new Object[0]);
            return CommandResult.SUCCESS;
        }
        if (!(mode.equals("off") || mode.equals("false") || mode.equals("paste") || mode.equals("upload"))) {
            this.sendUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        VerboseListener listener = plugin.getVerboseHandler().unregisterListener(sender.getUuid());
        if (!mode.equals("paste") && !mode.equals("upload")) {
            Message.VERBOSE_OFF.send(sender, new Object[0]);
            return CommandResult.SUCCESS;
        }
        if (listener == null) {
            Message.VERBOSE_OFF.send(sender, new Object[0]);
            return CommandResult.SUCCESS;
        }
        Message.VERBOSE_UPLOAD_START.send(sender, new Object[0]);
        String id = listener.uploadPasteData();
        String url = plugin.getConfiguration().get(ConfigKeys.VERBOSE_VIEWER_URL_PATTERN) + "?" + id;
        Message.VERBOSE_RESULTS_URL.send(sender, new Object[0]);
        TextComponent message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder((String)url).color(TextColor.AQUA)).clickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, String.valueOf(url)))).hoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Component)TextComponent.of((String)"Click to open the results page.").color(TextColor.GRAY)))).build();
        sender.sendMessage((Component)message);
        return CommandResult.SUCCESS;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        if (args.isEmpty()) {
            return ImmutableList.of((Object)"on", (Object)"record", (Object)"off", (Object)"upload");
        }
        if (args.size() == 1) {
            return Stream.of("on", "record", "off", "upload").filter(s -> s.toLowerCase().startsWith(((String)args.get(0)).toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

