/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.config.LuckPermsConfiguration;
import me.lucko.luckperms.common.contexts.ContextSetJsonSerializer;
import me.lucko.luckperms.common.utils.gson.GsonProvider;

public class ContextsFile {
    private final LuckPermsConfiguration configuration;
    private ImmutableContextSet staticContexts = ImmutableContextSet.empty();
    private ImmutableContextSet defaultContexts = ImmutableContextSet.empty();

    public ContextsFile(LuckPermsConfiguration configuration) {
        this.configuration = configuration;
    }

    public void load() {
        Path file = this.configuration.getPlugin().getBootstrap().getDataDirectory().resolve("contexts.json");
        Path oldFile = this.configuration.getPlugin().getBootstrap().getDataDirectory().resolve("static-contexts.json");
        if (Files.exists(oldFile, new LinkOption[0])) {
            try {
                Files.move(oldFile, file, new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!Files.exists(file, new LinkOption[0])) {
            this.save();
            return;
        }
        boolean save = false;
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            JsonObject data = (JsonObject)GsonProvider.normal().fromJson((Reader)reader, JsonObject.class);
            if (data.has("context")) {
                this.staticContexts = ContextSetJsonSerializer.deserializeContextSet((JsonElement)data.get("context").getAsJsonObject()).makeImmutable();
                save = true;
            }
            if (data.has("static-contexts")) {
                this.staticContexts = ContextSetJsonSerializer.deserializeContextSet((JsonElement)data.get("static-contexts").getAsJsonObject()).makeImmutable();
            }
            if (data.has("default-contexts")) {
                this.defaultContexts = ContextSetJsonSerializer.deserializeContextSet((JsonElement)data.get("default-contexts").getAsJsonObject()).makeImmutable();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (save) {
            this.save();
        }
    }

    public void save() {
        Path file = this.configuration.getPlugin().getBootstrap().getDataDirectory().resolve("contexts.json");
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            JsonObject data = new JsonObject();
            data.add("static-contexts", (JsonElement)ContextSetJsonSerializer.serializeContextSet(this.staticContexts));
            data.add("default-contexts", (JsonElement)ContextSetJsonSerializer.serializeContextSet(this.defaultContexts));
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)data, (Appendable)writer);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ImmutableContextSet getStaticContexts() {
        return this.staticContexts;
    }

    public ImmutableContextSet getDefaultContexts() {
        return this.defaultContexts;
    }
}

