/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.inheritance;

import java.util.List;
import java.util.TreeSet;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.LocalizedNode;
import me.lucko.luckperms.api.LookupSetting;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.common.inheritance.InheritanceGraph;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;

public class InheritanceHandler {
    private final LuckPermsPlugin plugin;
    private final InheritanceGraph nonContextualGraph;
    private final InheritanceGraph allowAllContextualGraph;
    private final InheritanceGraph globalContextualGraph;

    public InheritanceHandler(LuckPermsPlugin plugin) {
        this.plugin = plugin;
        this.nonContextualGraph = new NonContextualGraph(plugin);
        this.allowAllContextualGraph = new ContextualGraph(plugin, Contexts.allowAll());
        this.globalContextualGraph = new ContextualGraph(plugin, Contexts.global());
    }

    public InheritanceGraph getGraph() {
        return this.nonContextualGraph;
    }

    public InheritanceGraph getGraph(Contexts contexts) {
        if (contexts == Contexts.allowAll()) {
            return this.allowAllContextualGraph;
        }
        if (contexts == Contexts.global()) {
            return this.globalContextualGraph;
        }
        return new ContextualGraph(this.plugin, contexts);
    }

    private static final class ContextualGraph
    implements InheritanceGraph {
        private final LuckPermsPlugin plugin;
        private final Contexts context;

        ContextualGraph(LuckPermsPlugin plugin, Contexts context) {
            this.plugin = plugin;
            this.context = context;
        }

        @Override
        public Iterable<? extends PermissionHolder> successors(PermissionHolder holder) {
            TreeSet<Group> successors = new TreeSet<Group>(holder.getInheritanceComparator());
            List<LocalizedNode> nodes = holder.getOwnGroupNodes(this.context.getContexts());
            for (Node node : nodes) {
                Group g;
                if (!this.context.hasSetting(LookupSetting.APPLY_PARENTS_SET_WITHOUT_SERVER) && !node.isServerSpecific() || !this.context.hasSetting(LookupSetting.APPLY_PARENTS_SET_WITHOUT_WORLD) && !node.isWorldSpecific() || (g = (Group)this.plugin.getGroupManager().getIfLoaded(node.getGroupName())) == null) continue;
                successors.add(g);
            }
            return successors;
        }
    }

    private static final class NonContextualGraph
    implements InheritanceGraph {
        private final LuckPermsPlugin plugin;

        NonContextualGraph(LuckPermsPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public Iterable<? extends PermissionHolder> successors(PermissionHolder holder) {
            TreeSet<Group> successors = new TreeSet<Group>(holder.getInheritanceComparator());
            List<LocalizedNode> nodes = holder.getOwnGroupNodes();
            for (Node node : nodes) {
                Group g = (Group)this.plugin.getGroupManager().getIfLoaded(node.getGroupName());
                if (g == null) continue;
                successors.add(g);
            }
            return successors;
        }
    }
}

