/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.model;

import java.util.Objects;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.node.factory.NodeFactory;

public final class NodeDataContainer {
    private final String permission;
    private final boolean value;
    private final String server;
    private final String world;
    private final long expiry;
    private final ImmutableContextSet contexts;
    private Node node = null;

    public static NodeDataContainer fromNode(Node node) {
        NodeDataContainer model = NodeDataContainer.of(node.getPermission(), node.getValue(), node.getServer().orElse("global"), node.getWorld().orElse("global"), node.isTemporary() ? node.getExpiryUnixTime() : 0L, node.getContexts().makeImmutable());
        model.node = node;
        return model;
    }

    public static NodeDataContainer of(String permission, boolean value, String server, String world, long expiry, ImmutableContextSet contexts) {
        return new NodeDataContainer(permission, value, server, world, expiry, contexts);
    }

    public static NodeDataContainer of(String permission) {
        return NodeDataContainer.of(permission, true, "global", "global", 0L, ImmutableContextSet.empty());
    }

    private NodeDataContainer(String permission, boolean value, String server, String world, long expiry, ImmutableContextSet contexts) {
        this.permission = Objects.requireNonNull(permission, "permission");
        this.value = value;
        this.server = Objects.requireNonNull(server, "server");
        this.world = Objects.requireNonNull(world, "world");
        this.expiry = expiry;
        this.contexts = Objects.requireNonNull(contexts, "contexts");
    }

    public synchronized Node toNode() {
        if (this.node == null) {
            this.node = NodeFactory.builder(this.permission).setValue(this.value).setServer(this.server).setWorld(this.world).setExpiry(this.expiry).withExtraContext(this.contexts).build();
        }
        return this.node;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean getValue() {
        return this.value;
    }

    public String getServer() {
        return this.server;
    }

    public String getWorld() {
        return this.world;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public ImmutableContextSet getContexts() {
        return this.contexts;
    }

    public NodeDataContainer setPermission(String permission) {
        return NodeDataContainer.of(permission, this.value, this.server, this.world, this.expiry, this.contexts);
    }

    public NodeDataContainer setValue(boolean value) {
        return NodeDataContainer.of(this.permission, value, this.server, this.world, this.expiry, this.contexts);
    }

    public NodeDataContainer setServer(String server) {
        return NodeDataContainer.of(this.permission, this.value, server, this.world, this.expiry, this.contexts);
    }

    public NodeDataContainer setWorld(String world) {
        return NodeDataContainer.of(this.permission, this.value, this.server, world, this.expiry, this.contexts);
    }

    public NodeDataContainer setExpiry(long expiry) {
        return NodeDataContainer.of(this.permission, this.value, this.server, this.world, expiry, this.contexts);
    }

    public NodeDataContainer setContexts(ImmutableContextSet contexts) {
        return NodeDataContainer.of(this.permission, this.value, this.server, this.world, this.expiry, contexts);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeDataContainer)) {
            return false;
        }
        NodeDataContainer other = (NodeDataContainer)o;
        return this.getPermission().equals(other.getPermission()) && this.getValue() == other.getValue() && this.getServer().equals(other.getServer()) && this.getWorld().equals(other.getWorld()) && this.getExpiry() == other.getExpiry() && this.getContexts().equals(other.getContexts());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPermission().hashCode();
        result = result * 59 + Boolean.hashCode(this.getValue());
        result = result * 59 + this.getServer().hashCode();
        result = result * 59 + this.getWorld().hashCode();
        result = result * 59 + Long.hashCode(this.getExpiry());
        result = result * 59 + this.getContexts().hashCode();
        return result;
    }

    public String toString() {
        return "NodeModel(permission=" + this.getPermission() + ", value=" + this.getValue() + ", server=" + this.getServer() + ", world=" + this.getWorld() + ", expiry=" + this.getExpiry() + ", contexts=" + this.getContexts() + ")";
    }
}

