/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.processors;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.common.processors.AbstractPermissionProcessor;
import me.lucko.luckperms.common.processors.PermissionProcessor;

public class WildcardProcessor
extends AbstractPermissionProcessor
implements PermissionProcessor {
    public static final String WILDCARD_SUFFIX = ".*";
    private static final String GLOBAL_WILDCARD = "*";
    private static final String GLOBAL_WILDCARD_WITH_QUOTES = "'*'";
    private Map<String, Boolean> wildcardPermissions = Collections.emptyMap();
    private Tristate globalWildcardState = Tristate.UNDEFINED;

    @Override
    public Tristate hasPermission(String permission) {
        int endIndex;
        String node = permission;
        while ((endIndex = node.lastIndexOf(46)) != -1) {
            Tristate t;
            if ((node = node.substring(0, endIndex)).isEmpty() || (t = Tristate.fromNullableBoolean(this.wildcardPermissions.get(node))) == Tristate.UNDEFINED) continue;
            return t;
        }
        return this.globalWildcardState;
    }

    @Override
    public void refresh() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry e : this.sourceMap.entrySet()) {
            String key = (String)e.getKey();
            if (!key.endsWith(WILDCARD_SUFFIX) || key.length() <= 2) continue;
            builder.put((Object)key.substring(0, key.length() - 2), e.getValue());
        }
        this.wildcardPermissions = builder.build();
        Tristate state = Tristate.fromNullableBoolean((Boolean)this.sourceMap.get(GLOBAL_WILDCARD));
        if (state == Tristate.UNDEFINED) {
            state = Tristate.fromNullableBoolean((Boolean)this.sourceMap.get(GLOBAL_WILDCARD_WITH_QUOTES));
        }
        this.globalWildcardState = state;
    }
}

