/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import java.util.List;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.sponge.commands.SpongeCommandUtils;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;

public class PermissionSet
extends SubCommand<LPSubjectData> {
    public PermissionSet(LocaleManager locale) {
        super(CommandSpec.SPONGE_PERMISSION_SET.localize(locale), "set", CommandPermission.SPONGE_PERMISSION_SET, Predicates.inRange(0, 1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, LPSubjectData subjectData, List<String> args, String label) throws CommandException {
        String node = args.get(0);
        Tristate tristate = SpongeCommandUtils.parseTristate(1, args);
        ImmutableContextSet contextSet = ArgumentParser.parseContextSponge(2, args);
        if (subjectData.setPermission(contextSet, node, tristate).join().booleanValue()) {
            MessageUtils.sendPluginMessage(sender, "&aSet &b" + node + "&a to &b" + tristate.toString().toLowerCase() + "&a in context " + SpongeCommandUtils.contextToString(contextSet, plugin.getLocaleManager()));
        } else {
            MessageUtils.sendPluginMessage(sender, "Unable to set permission. Does the Subject already have it set?");
        }
        return CommandResult.SUCCESS;
    }
}

