/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.contexts;

import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.contexts.ContextManager;
import me.lucko.luckperms.common.contexts.ContextsCache;
import me.lucko.luckperms.common.contexts.ContextsSupplier;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import org.spongepowered.api.service.permission.Subject;

public class SpongeContextManager
extends ContextManager<Subject> {
    private final LoadingCache<Subject, ContextsCache<Subject>> subjectCaches = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build(key -> new ContextsCache<Subject>((Subject)key, this));

    public SpongeContextManager(LPSpongePlugin plugin) {
        super(plugin, Subject.class);
    }

    @Override
    public ContextsSupplier getCacheFor(Subject subject) {
        if (subject == null) {
            throw new NullPointerException("subject");
        }
        return (ContextsSupplier)this.subjectCaches.get((Object)subject);
    }

    @Override
    public void invalidateCache(Subject subject) {
        if (subject == null) {
            throw new NullPointerException("subject");
        }
        ContextsCache cache = (ContextsCache)this.subjectCaches.getIfPresent((Object)subject);
        if (cache != null) {
            cache.invalidate();
        }
    }

    @Override
    public Contexts formContexts(Subject subject, ImmutableContextSet contextSet) {
        return this.formContexts(contextSet);
    }
}

