/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.misc;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.sponge.service.model.LPPermissionDescription;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectCollection;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import me.lucko.luckperms.sponge.service.proxy.ProxyFactory;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.text.Text;

public final class SimplePermissionDescription
implements LPPermissionDescription {
    private final LPPermissionService service;
    private final String id;
    private final @Nullable Text description;
    private final @Nullable PluginContainer owner;
    private PermissionDescription spongeProxy = null;

    public SimplePermissionDescription(LPPermissionService service, String id, @Nullable Text description, @Nullable PluginContainer owner) {
        this.service = service;
        this.id = Objects.requireNonNull(id, "id");
        this.description = description;
        this.owner = owner;
    }

    @Override
    public synchronized PermissionDescription sponge() {
        if (this.spongeProxy == null) {
            this.spongeProxy = ProxyFactory.toSponge(this);
        }
        return this.spongeProxy;
    }

    @Override
    public LPPermissionService getService() {
        return this.service;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Optional<Text> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public Optional<PluginContainer> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    @Override
    public CompletableFuture<Map<LPSubjectReference, Boolean>> findAssignedSubjects(String id) {
        LPSubjectCollection collection = this.service.getCollection(id);
        return collection.getAllWithPermission(this.id);
    }

    @Override
    public Map<LPSubject, Boolean> getAssignedSubjects(String id) {
        LPSubjectCollection collection = this.service.getCollection(id);
        return collection.getLoadedWithPermission(this.id);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimplePermissionDescription)) {
            return false;
        }
        SimplePermissionDescription other = (SimplePermissionDescription)o;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "PermissionDescription(id=" + this.id + ", description=" + this.description + ", owner=" + this.owner + ")";
    }
}

