/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.persisted;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.buffers.BufferedRequest;
import me.lucko.luckperms.common.model.NodeMapType;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.sponge.service.LuckPermsService;
import me.lucko.luckperms.sponge.service.calculated.CalculatedSubject;
import me.lucko.luckperms.sponge.service.calculated.CalculatedSubjectData;
import me.lucko.luckperms.sponge.service.calculated.MonitoredSubjectData;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import me.lucko.luckperms.sponge.service.persisted.PersistedCollection;
import me.lucko.luckperms.sponge.service.persisted.PersistedSubjectData;
import me.lucko.luckperms.sponge.service.persisted.SubjectDataContainer;
import me.lucko.luckperms.sponge.service.proxy.ProxyFactory;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.service.permission.Subject;

public class PersistedSubject
extends CalculatedSubject
implements LPSubject {
    private final LuckPermsService service;
    private final String identifier;
    private final PersistedCollection parentCollection;
    private final PersistedSubjectData subjectData;
    private final CalculatedSubjectData transientSubjectData;
    private Subject spongeSubject = null;
    private final SaveBuffer saveBuffer;
    private boolean pendingSave = false;

    public PersistedSubject(LuckPermsService service, PersistedCollection parentCollection, String identifier) {
        super(service.getPlugin());
        this.service = service;
        this.parentCollection = parentCollection;
        this.identifier = identifier;
        this.subjectData = new PersistedSubjectData(this, NodeMapType.ENDURING, service){

            @Override
            protected void onUpdate(boolean success) {
                super.onUpdate(success);
                if (success) {
                    PersistedSubject.this.fireUpdateEvent(this);
                }
            }
        };
        this.transientSubjectData = new MonitoredSubjectData(this, NodeMapType.TRANSIENT, service){

            @Override
            protected void onUpdate(boolean success) {
                if (success) {
                    PersistedSubject.this.fireUpdateEvent(this);
                }
            }
        };
        this.saveBuffer = new SaveBuffer(service.getPlugin());
    }

    private void fireUpdateEvent(LPSubjectData subjectData) {
        this.service.getPlugin().getUpdateEventHandler().fireUpdateEvent(subjectData);
    }

    public void loadData(SubjectDataContainer container) {
        if (this.pendingSave) {
            return;
        }
        this.subjectData.setSave(false);
        container.applyToData(this.subjectData);
        this.subjectData.setSave(true);
    }

    public void save() {
        this.pendingSave = true;
        this.saveBuffer.request();
    }

    void doSave() {
        try {
            this.service.getStorage().saveToFile(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pendingSave = false;
        }
    }

    @Override
    public Subject sponge() {
        if (this.spongeSubject == null) {
            this.spongeSubject = ProxyFactory.toSponge(this);
        }
        return this.spongeSubject;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public LuckPermsService getService() {
        return this.service;
    }

    @Override
    public PersistedCollection getParentCollection() {
        return this.parentCollection;
    }

    @Override
    public PersistedSubjectData getSubjectData() {
        return this.subjectData;
    }

    @Override
    public CalculatedSubjectData getTransientSubjectData() {
        return this.transientSubjectData;
    }

    @Override
    public Optional<CommandSource> getCommandSource() {
        return Optional.empty();
    }

    private final class SaveBuffer
    extends BufferedRequest<Void> {
        public SaveBuffer(LuckPermsPlugin plugin) {
            super(1L, TimeUnit.SECONDS, plugin.getBootstrap().getScheduler());
        }

        @Override
        protected Void perform() {
            PersistedSubject.this.doSave();
            return null;
        }
    }
}

