/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.brewer;

import cofh.thermalexpansion.block.machine.TileBrewer;
import cofh.thermalexpansion.block.machine.TileRefinery;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.JEIPluginTE;
import cofh.thermalexpansion.plugins.jei.machine.BaseRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.BrewerManager;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BrewerRecipeWrapper
extends BaseRecipeWrapper {
    protected List<ItemStack> inputItems;
    protected List<FluidStack> inputFluids;
    protected List<FluidStack> outputFluids;
    protected IDrawableAnimated fluid;
    protected IDrawableAnimated progress;
    protected IDrawableAnimated speed;

    public BrewerRecipeWrapper(IGuiHelper guiHelper, BrewerManager.BrewerRecipe recipe) {
        this(guiHelper, recipe, "thermalexpansion.brewer");
    }

    public BrewerRecipeWrapper(IGuiHelper guiHelper, BrewerManager.BrewerRecipe recipe, String uIdIn) {
        this.uId = uIdIn;
        ArrayList<ItemStack> recipeInputs = new ArrayList<ItemStack>();
        recipeInputs.add(recipe.getInput());
        ArrayList<FluidStack> recipeInputFluids = new ArrayList<FluidStack>();
        recipeInputFluids.add(recipe.getInputFluid());
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        recipeOutputFluids.add(recipe.getOutputFluid());
        this.inputItems = recipeInputs;
        this.inputFluids = recipeInputFluids;
        this.outputFluids = recipeOutputFluids;
        this.energy = recipe.getEnergy();
        IDrawableStatic fluidDrawable = Drawables.getDrawables(guiHelper).getProgress(2);
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getProgressFill(2);
        IDrawableStatic speedDrawable = Drawables.getDrawables(guiHelper).getScaleFill(0);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        this.fluid = guiHelper.createAnimatedDrawable(fluidDrawable, this.energy / TileRefinery.basePower, IDrawableAnimated.StartDirection.LEFT, true);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, this.energy / TileBrewer.basePower, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(speedDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.inputItems);
        ingredients.setInputs(FluidStack.class, this.inputFluids);
        ingredients.setOutputs(FluidStack.class, this.outputFluids);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        JEIPluginTE.drawFluid(94, 23, this.outputFluids.get(0), 24, 16);
        this.fluid.draw(minecraft, 94, 23);
        this.progress.draw(minecraft, 94, 23);
        this.speed.draw(minecraft, 46, 23);
        this.energyMeter.draw(minecraft, 2, 8);
    }
}

