/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.IC2;
import ic2.core.block.crop.crops.CropCardBase;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropVenomilia
extends CropCardBase {
    public CropVenomilia() {
        super(new CropProperties(3, 3, 1, 3, 3, 3));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state <= 3) {
            return this.getSprite("bc")[11 + state];
        }
        if (state == 4) {
            return this.getSprite("bc")[23];
        }
        return this.getSprite("bc")[25];
    }

    @Override
    public String getId() {
        return "Venomilia";
    }

    @Override
    public String getDiscoveredBy() {
        return "raGan";
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Purple", "Flower", "Tulip", "Poison"};
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() <= 4 && cropTile.getLightLevel() >= 12 || cropTile.getCurrentSize() == 5;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() >= 4;
    }

    @Override
    public int getMaxSize() {
        return 6;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        if (crop.getCurrentSize() == 5) {
            return Ic2Items.grinPowder.func_77946_l();
        }
        if (crop.getCurrentSize() >= 4) {
            return new ItemStack(Items.field_151100_aR, 1, 5);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 3;
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        if (cropTile.getCurrentSize() >= 3) {
            return 600;
        }
        return 400;
    }

    @Override
    public boolean onRightClick(ICropTile cropTile, EntityPlayer player) {
        if (!player.func_70093_af()) {
            this.onEntityCollision(cropTile, (Entity)player);
        }
        return cropTile.performManualHarvest();
    }

    @Override
    public boolean onLeftClick(ICropTile cropTile, EntityPlayer player) {
        if (!player.func_70093_af()) {
            this.onEntityCollision(cropTile, (Entity)player);
        }
        return cropTile.pick();
    }

    @Override
    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        if (crop.getCurrentSize() == 5 && entity instanceof EntityLivingBase) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70093_af() && IC2.random.nextInt(50) != 0) {
                return super.onEntityCollision(crop, entity);
            }
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, (IC2.random.nextInt(10) + 5) * 20));
            crop.setCurrentSize(4);
            crop.updateState();
        }
        return super.onEntityCollision(crop, entity);
    }

    @Override
    public boolean isWeed(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 5 && cropTile.getStatGrowth() >= 8;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 5;
    }
}

