/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.tile;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IEUStorage;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.ElectricItem;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.util.info.EnergyInfo;
import ic2.core.block.base.util.info.MaxInputInfo;
import ic2.core.block.base.util.info.SinkTierInfo;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IClickable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityLuminator
extends TileEntityBlock
implements ITickable,
IEnergySink,
IEUStorage,
IClickable {
    public int energy;
    int ticker;
    @NetworkField(index=3)
    public IEnergyConductorColored.WireColor color = IEnergyConductorColored.WireColor.Blank;
    public boolean addedToEnergyNet = false;
    public boolean ignoreBlockStay = false;
    @NetworkField(index=4)
    public ItemStack glass = ItemStack.field_190927_a;

    public TileEntityLuminator() {
        this.addNetworkFields("color", "glass");
        this.addInfos(new SinkTierInfo(this), new EnergyInfo(this), new MaxInputInfo(this));
    }

    @Override
    public int getStoredEU() {
        return this.energy;
    }

    @Override
    public int getMaxEU() {
        return 50;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy = nbt.func_74765_d("energy");
        this.ignoreBlockStay = nbt.func_74767_n("Ignore");
        this.color = IEnergyConductorColored.WireColor.valueLookup[nbt.func_74762_e("Color")];
        if (nbt.func_74764_b("Glass")) {
            this.glass = new ItemStack(nbt.func_74775_l("Glass"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74777_a("energy", (short)this.energy);
        nbt.func_74757_a("Ignore", this.ignoreBlockStay);
        nbt.func_74768_a("Color", this.color.ordinal());
        if (this.glass != null) {
            NBTTagCompound data = new NBTTagCompound();
            this.glass.func_77955_b(data);
            nbt.func_74782_a("Glass", (NBTBase)data);
        }
        return nbt;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("glass") || field.equals("color")) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
        if (field.equals("isActive")) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
        }
    }

    public void func_73660_a() {
        if (this.getActive()) {
            if (this.ticker++ % 4 == 0) {
                --this.energy;
                if (this.energy <= 0) {
                    this.setActive(false);
                }
            }
        } else if (this.energy > 0) {
            this.setActive(true);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.addedToEnergyNet && this.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.addedToEnergyNet && this.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return false;
    }

    @Override
    public void setFacing(EnumFacing face) {
    }

    public void setSide(EnumFacing face) {
        super.setFacing(face);
    }

    public void setColor(IEnergyConductorColored.WireColor newColor) {
        this.color = newColor;
        this.getNetwork().updateTileEntityField(this, "color");
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.8;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return emitter instanceof IEnergyConductor && side.func_176734_d() == this.getFacing() && EnergyNet.instance.getPos(emitter).func_177972_a(side.func_176734_d()).equals((Object)this.func_174877_v());
    }

    @Override
    public double getDemandedEnergy() {
        return 50 - this.energy;
    }

    @Override
    public int getSinkTier() {
        return 1;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        if (amount > 32.0 || amount <= 0.0) {
            return 0.0;
        }
        if (amount <= 0.0) {
            return 0.0;
        }
        this.energy = (int)((double)this.energy + amount);
        int re = 0;
        if (this.energy > 50) {
            re = this.energy - 50;
            this.energy = 50;
        }
        return re;
    }

    public void setGlass(ItemStack item) {
        this.glass = item;
        this.getNetwork().updateTileEntityField(this, "glass");
    }

    public ItemStack getGlass() {
        return this.glass;
    }

    public IBlockState getGlassAsBlock() {
        if (this.glass.func_190926_b()) {
            return null;
        }
        Item item = this.glass.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        if (block == null) {
            return null;
        }
        return block.func_176203_a(item.func_77647_b(this.glass.func_77960_j()));
    }

    @Override
    public boolean hasRightClick() {
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing face, Side side) {
        ItemStack handItem = player.func_184586_b(hand);
        if (handItem.func_190926_b()) {
            if (!this.glass.func_190926_b() && player.func_70093_af()) {
                if (this.isSimulating()) {
                    StackUtil.dropAsEntity(this.field_145850_b, this.func_174877_v(), this.glass.func_77946_l());
                    this.setGlass(ItemStack.field_190927_a);
                }
                return true;
            }
            return false;
        }
        if (this.glass.func_190926_b() && (StackUtil.hasOreTag("blockGlass", handItem) || StackUtil.isStackEqual(handItem, Ic2Items.reinforcedGlass) || StackUtil.isStackEqual(handItem, Ic2Items.reinforcedGlassClear))) {
            this.setGlass(handItem.func_77979_a(1));
            player.field_71070_bA.func_75142_b();
            return true;
        }
        if (this.getDemandedEnergy() < 1.0) {
            return false;
        }
        int adding = (int)ElectricItem.manager.discharge(handItem, 10000 - this.energy, 3, true, true, false);
        if (adding > 0) {
            this.energy += adding;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLeftClick() {
        return false;
    }

    @Override
    public void onLeftClick(EntityPlayer player, Side side) {
    }
}

