/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.reactorPlanner;

import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.container.ContainerReactorPlanner;
import ic2.core.block.machine.med.logic.encoder.ByteShifter;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IC2Button;
import ic2.core.inventory.gui.buttons.ToolTipButton;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

public class ReactorPlannerGridComp
extends GuiComponent {
    TileEntityReactorPlanner planner;
    int lastID = -1;

    public ReactorPlannerGridComp(TileEntityReactorPlanner tile) {
        super(Ic2GuiComp.nullBox);
        this.planner = tile;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.GuiTick);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        int i;
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        int remove = this.planner.reactorSize * 9;
        for (i = 0; i < 3 + this.planner.reactorSize; ++i) {
            this.drawRow(gui, 60 + i * 18 - remove, 20, 6);
        }
        gui.func_73729_b(x + 200, y, 74, 212, 40, 38);
        gui.func_73729_b(x + 240, y, 79, 212, 43, 38);
        gui.func_73729_b(x + 208, y + 198, 74, 241, 40, 14);
        gui.func_73729_b(x + 240, y + 198, 79, 241, 48, 14);
        gui.func_73729_b(x + 200, y + 170, 74, 215, 40, 36);
        gui.func_73729_b(x + 240, y + 170, 79, 215, 43, 36);
        for (i = 1; i < 5; ++i) {
            int offset = i * 36;
            gui.func_73729_b(x + 200, y + offset, 74, 215, 40, 36);
            gui.func_73729_b(x + 240, y + offset, 79, 215, 43, 36);
        }
        for (i = 0; i < 3; ++i) {
            this.drawRow(gui, 215 + i * 18, 17, 5);
        }
        int row = this.planner.selectedSlot / 3;
        int slot = this.planner.selectedSlot % 3;
        gui.func_73729_b(x + 215 + slot * 18, y + 17 + 18 * row, 0, 230, 18, 18);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawRow(GuiIC2 gui, int xOffset, int yOffset, int count) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        for (int i = 0; i < count; ++i) {
            gui.func_73729_b(x + xOffset, y + yOffset + 18 * i, 0, 212, 18, 18);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiTick(GuiIC2 gui) {
        int amount;
        if (this.lastID != this.planner.components.type) {
            this.lastID = this.planner.components.type;
            gui.getCastedButton(2, ToolTipButton.class).clearText().addText(this.getCategoryName());
        }
        gui.getButton((int)0).field_146124_l = this.planner.components.canDecrease();
        gui.getButton((int)1).field_146124_l = this.planner.components.canIncrease();
        gui.getButton((int)3).field_146124_l = this.planner.reactorSize > 0;
        gui.getButton((int)4).field_146124_l = this.planner.reactorSize < 6;
        Slot hoverSlot = gui.getSlotUnderMouse();
        if (hoverSlot instanceof ContainerReactorPlanner.SlotComponent && (double)(amount = Mouse.getDWheel()) != 0.0) {
            ByteShifter shifter = new ByteShifter();
            shifter.writeInteger(0, 2);
            shifter.writeInteger(0, 3);
            this.planner.getNetwork().initiateClientTileEntityEvent(this.planner, shifter.getEncodedData(), -(amount /= 120));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        gui.registerButton(new IC2Button(0, x + 207, y + 5, 10, 10, "-"));
        gui.registerButton(new IC2Button(1, x + 265, y + 5, 10, 10, "+"));
        gui.registerButton(new ToolTipButton(2, x + 220, y + 5, 42, 10, Ic2GuiLang.categoryButton).addText(this.getCategoryName()));
        gui.registerButton(new IC2Button(3, x + 5, y + 5, 10, 10, "-"));
        gui.registerButton(new IC2Button(4, x + 157, y + 5, 10, 10, "+"));
    }

    private LocaleComp getCategoryName() {
        switch (this.planner.components.type) {
            case 0: {
                return Ic2GuiLang.categoryRods;
            }
            case 1: {
                return Ic2GuiLang.categoryCoolant;
            }
            case 2: {
                return Ic2GuiLang.categoryCondensators;
            }
            case 3: {
                return Ic2GuiLang.categoryHeatPacks;
            }
            case 4: {
                return Ic2GuiLang.categoryVents;
            }
            case 5: {
                return Ic2GuiLang.categorySpreadVents;
            }
            case 6: {
                return Ic2GuiLang.categorySwitches;
            }
            case 7: {
                return Ic2GuiLang.categoryPlates;
            }
            case 8: {
                return Ic2GuiLang.categoryReflectors;
            }
            case 9: {
                return Ic2GuiLang.categoryIsotopics;
            }
        }
        return Ic2GuiLang.categoryAll;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        int id = button.field_146127_k;
        ByteShifter shifter = new ByteShifter();
        int value = 0;
        if (id == 0 || id == 1) {
            shifter.writeInteger(0, 2);
            value = id == 0 ? -1 : 1;
        } else if (id == 2) {
            shifter.writeInteger(1, 2);
        } else if (id == 3 || id == 4) {
            shifter.writeInteger(2, 2);
            value = id == 3 ? -1 : 1;
            this.planner.reactorSize += value;
            if (this.planner.reactorSize < 0) {
                this.planner.reactorSize = 0;
            }
            if (this.planner.reactorSize > 6) {
                this.planner.reactorSize = 6;
            }
            this.planner.getReactorLogic().onSizeUpdate();
            ContainerReactorPlanner cont = gui.getContainer(ContainerReactorPlanner.class);
            if (cont != null) {
                cont.reset(gui.getPlayer().field_71071_by);
            }
        } else {
            return;
        }
        shifter.writeInteger(0, 3);
        this.planner.getNetwork().initiateClientTileEntityEvent(this.planner, shifter.getEncodedData(), value);
    }
}

