/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.inv.logics;

import ic2.api.item.ElectricItem;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.IC2;
import ic2.core.entity.IC2DamageSource;
import ic2.core.entity.explosion.ExplosionIC2;
import ic2.core.inventory.base.TickableLogic;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class NuclearJetpackLogic
extends TickableLogic
implements IReactor {
    NonNullList<ItemStack> inventory;
    public int tick;
    public float output;
    public int heat;
    public int componentHeat;
    public int maxHeat;
    public float hem;
    public boolean active;
    public EntityEquipmentSlot slot;

    public NuclearJetpackLogic(ItemStack stack, EntityPlayer player, EntityEquipmentSlot playerSlot) {
        super(stack, player);
        this.slot = playerSlot;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.inventory = NonNullList.func_191197_a((int)25, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            byte b0 = data.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.inventory.size()) continue;
            this.inventory.set((int)b0, (Object)new ItemStack(data));
        }
        this.tick = nbt.func_74762_e("CurrentTick");
        this.active = nbt.func_74767_n("Active");
        this.heat = nbt.func_74762_e("Heat");
        this.output = nbt.func_74760_g("output");
        this.componentHeat = nbt.func_74762_e("ComponentHeat");
        this.maxHeat = nbt.func_74762_e("MaxHeat");
        this.hem = nbt.func_74760_g("Hem");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventory.size(); ++i) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventory.get(i)).func_77955_b(data);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
        nbt.func_74768_a("CurrentTick", this.tick);
        nbt.func_74757_a("Active", this.active);
        nbt.func_74768_a("Heat", this.heat);
        nbt.func_74776_a("output", this.output);
        nbt.func_74768_a("ComponentHeat", this.componentHeat);
        nbt.func_74768_a("MaxHeat", this.maxHeat);
        nbt.func_74776_a("Hem", this.hem);
    }

    @Override
    public TileEntity getCoreTe() {
        return null;
    }

    @Override
    public BlockPos getPosition() {
        return this.getPlayer().func_180425_c();
    }

    @Override
    public World getWorldObj() {
        return this.getPlayer().func_130014_f_();
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(int heat) {
        this.heat = heat;
    }

    @Override
    public int addHeat(int amount) {
        return this.heat += amount;
    }

    @Override
    public int getMaxHeat() {
        return this.maxHeat;
    }

    @Override
    public void setMaxHeat(int newMaxHeat) {
        this.maxHeat = newMaxHeat;
    }

    @Override
    public void addEmitHeat(int heat) {
    }

    @Override
    public float getHeatEffectModifier() {
        return this.hem;
    }

    @Override
    public void setHeatEffectModifier(float newHEM) {
        this.hem = newHEM;
    }

    @Override
    public float getReactorEnergyOutput() {
        return this.output;
    }

    @Override
    public double getReactorEUEnergyOutput() {
        return this.output * (float)IC2.config.getInt("energyGeneratorNuclear");
    }

    @Override
    public float addOutput(float energy) {
        return this.output += energy;
    }

    @Override
    public ItemStack getItemAt(int x, int y) {
        if (x < 0 || x > 4 || y < 0 || y > 4) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.inventory.get(x + y * 5);
    }

    @Override
    public void setItemAt(int x, int y, ItemStack item) {
        if (x < 0 || x > 4 || y < 0 || y > 4) {
            return;
        }
        this.inventory.set(x + y * 5, (Object)item);
    }

    @Override
    public void explode() {
        float boomPower = 10.0f;
        float boomMod = 1.0f;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                ItemStack stack = this.getItemAt(x, y);
                if (stack.func_77973_b() instanceof IReactorComponent) {
                    float f = ((IReactorComponent)stack.func_77973_b()).influenceExplosion(stack, this);
                    if (f > 0.0f && f < 1.0f) {
                        boomMod *= f;
                    } else {
                        boomPower += f;
                    }
                }
                this.setItemAt(x, y, ItemStack.field_190927_a);
            }
        }
        EntityPlayer player = this.getPlayer();
        IC2.log.info("Nuclear Jetpack at " + player.field_70170_p.field_73011_w.getDimension() + ":(" + player.field_70165_t + "," + player.field_70163_u + "," + player.field_70161_v + ") melted (explosion power " + (boomPower *= this.hem * boomMod) + ")");
        float maxPower = IC2.config.getFloat("explosionPowerReactorMax");
        if (boomPower > maxPower) {
            boomPower = maxPower;
        }
        this.setStack(player, ItemStack.field_190927_a);
        player.field_71070_bA.func_75142_b();
        ExplosionIC2 explosion = new ExplosionIC2(player.field_70170_p, null, new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v), boomPower, 0.01f, 1.5f, IC2DamageSource.nuke);
        explosion.doExplosion();
        IC2.achievements.issueStat(player, "nuclearJetpacksExploded");
    }

    public void setStack(EntityPlayer player, ItemStack stack) {
        player.func_184201_a(this.slot, stack);
    }

    @Override
    public int getTickRate() {
        return 20;
    }

    @Override
    public boolean produceEnergy() {
        return this.active;
    }

    @Override
    public boolean isFluidCooled() {
        return false;
    }

    @Override
    public void onTick(ItemStack stack) {
        if (this.tick++ % this.getTickRate() == 0) {
            this.updateState(stack);
            if (this.updateReactor()) {
                return;
            }
            this.updateComponentHeat();
        }
        if (this.active) {
            ElectricItem.manager.charge(stack, this.getReactorEUEnergyOutput(), Integer.MAX_VALUE, true, false);
            this.updateState(stack);
        }
    }

    public void updateComponentHeat() {
        double total = 0.0;
        int count = 0;
        for (int i = 0; i < this.inventory.size(); ++i) {
            IReactorComponent comp;
            int maxHeat;
            ItemStack component = (ItemStack)this.inventory.get(i);
            if (!(component.func_77973_b() instanceof IReactorComponent) || (maxHeat = (comp = (IReactorComponent)component.func_77973_b()).getMaxHeat(component, this, i % 5, i / 5)) <= 0) continue;
            total += (double)comp.getCurrentHeat(component, this, i % 5, i / 5) / (double)maxHeat * 100.0;
            ++count;
        }
        this.componentHeat = count > 0 ? (int)(total /= (double)count) : 0;
    }

    public boolean updateReactor() {
        this.output = 0.0f;
        this.maxHeat = 10000;
        this.hem = 1.0f;
        this.processChamber();
        return this.calculateHeatEffects();
    }

    public boolean calculateHeatEffects() {
        Material mat;
        IBlockState state;
        BlockPos coord;
        if (this.heat < 4000 || !IC2.platform.isSimulating() || IC2.config.getFloat("explosionPowerReactorMax") <= 0.0f) {
            return false;
        }
        float power = (float)this.heat / (float)this.maxHeat;
        if (power >= 1.0f) {
            this.explode();
            return true;
        }
        World worldObj = this.getWorldObj();
        if (power >= 0.85f && worldObj.field_73012_v.nextFloat() <= 0.2f * this.hem && (coord = this.getRandCoord(2)) != null) {
            state = worldObj.func_180495_p(coord);
            if (state.func_177230_c() == Blocks.field_150350_a) {
                worldObj.func_175656_a(coord, Blocks.field_150480_ab.func_176223_P());
            } else if (state.func_185887_b(worldObj, coord) <= -1.0f) {
                Material mat2 = state.func_185904_a();
                if (mat2 == Material.field_151576_e || mat2 == Material.field_151573_f || mat2 == Material.field_151587_i || mat2 == Material.field_151578_c || mat2 == Material.field_151571_B) {
                    worldObj.func_175656_a(coord, Blocks.field_150356_k.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(15)));
                } else {
                    worldObj.func_175656_a(coord, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
        if (power >= 0.7f) {
            BlockPos pos = this.getPosition();
            List list = worldObj.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_186662_g(3.0));
            for (int l = 0; l < list.size(); ++l) {
                ((EntityLivingBase)list.get(l)).func_70097_a((DamageSource)IC2DamageSource.radiation, (float)((int)((float)worldObj.field_73012_v.nextInt(4) * this.hem)));
            }
        }
        if (power >= 0.5f && worldObj.field_73012_v.nextFloat() <= this.hem && (coord = this.getRandCoord(2)) != null && (state = worldObj.func_180495_p(coord)).func_185904_a() == Material.field_151586_h) {
            worldObj.func_175698_g(coord);
        }
        if (power >= 0.4f && worldObj.field_73012_v.nextFloat() <= this.hem && (coord = this.getRandCoord(2)) != null && ((mat = worldObj.func_180495_p(coord).func_185904_a()) == Material.field_151575_d || mat == Material.field_151584_j || mat == Material.field_151580_n)) {
            worldObj.func_175656_a(coord, Blocks.field_150480_ab.func_176223_P());
        }
        return false;
    }

    public void processChamber() {
        for (int pass = 0; pass < 2; ++pass) {
            for (int x = 0; x < 5; ++x) {
                for (int y = 0; y < 5; ++y) {
                    ItemStack stack = this.getItemAt(x, y);
                    if (!(stack.func_77973_b() instanceof IReactorComponent)) continue;
                    IReactorComponent comp = (IReactorComponent)stack.func_77973_b();
                    comp.processChamber(stack, this, x, y, pass == 0);
                }
            }
        }
    }

    public void updateState(ItemStack stack) {
        double maxEnergy = ElectricItem.manager.getMaxCharge(stack);
        if (maxEnergy <= 0.0) {
            maxEnergy = 30000.0;
        }
        if (!this.active) {
            double produce = ElectricItem.manager.getCharge(stack) / maxEnergy * 100.0;
            if (produce < 30.0) {
                this.active = true;
            }
        } else if (ElectricItem.manager.getCharge(stack) >= maxEnergy) {
            this.active = false;
        }
    }

    public BlockPos getRandCoord(int radius) {
        if (radius <= 0) {
            return null;
        }
        BlockPos coords = this.getPosition();
        World worldObj = this.getWorldObj();
        Random rand = worldObj.field_73012_v;
        BlockPos newPos = coords.func_177982_a(rand.nextInt(2 * radius + 1) - radius, rand.nextInt(2 * radius + 1) - radius, rand.nextInt(2 * radius + 1) - radius);
        if (coords.equals((Object)newPos)) {
            return null;
        }
        return newPos;
    }
}

