/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.wind.misc;

import ic2.core.IC2;
import ic2.core.platform.wind.misc.RealisticWindProperty;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;

public class RealisticWindCalculation {
    boolean newRain;
    boolean newStorm;
    double newSpeed;
    float newRotation;
    int newYLevel;
    int newThickness;
    int newMaxTimeLeft;

    public RealisticWindCalculation(World world) {
        WorldInfo info = world.func_72912_H();
        this.newRain = info.func_76059_o();
        this.newStorm = info.func_76061_m();
        Random rand = world.field_73012_v;
        this.newYLevel = Math.min((int)world.field_73011_w.getHorizon() + rand.nextInt(world.func_72940_L()), world.func_72940_L());
        this.newThickness = Math.max(Math.min(rand.nextInt(8) - (rand.nextInt(14) - rand.nextInt(5)), 7), -7);
        this.newMaxTimeLeft = rand.nextInt(IC2.config.getInt("maxWindChangeDelay"));
        this.newSpeed = rand.nextInt(109);
        if (this.newStorm) {
            this.newSpeed *= 1.5;
        } else if (this.newRain) {
            this.newSpeed *= 1.25;
        }
        this.newRotation = rand.nextInt(360);
    }

    public RealisticWindCalculation(World world, double lastSpeed, float lastRotation) {
        WorldInfo info = world.func_72912_H();
        this.newRain = info.func_76059_o();
        this.newStorm = info.func_76061_m();
        Random rand = world.field_73012_v;
        this.newYLevel = Math.min((int)world.field_73011_w.getHorizon() + rand.nextInt(world.func_72940_L()), world.func_72940_L());
        this.newThickness = Math.max(Math.min(rand.nextInt(8) - (rand.nextInt(14) - rand.nextInt(5)), 7), -7);
        this.newMaxTimeLeft = rand.nextInt(IC2.config.getInt("maxWindChangeDelay"));
        this.newSpeed = lastSpeed + (double)this.getSpeedEffect(rand.nextInt(109), rand.nextInt(5));
        if (this.newSpeed < 0.0) {
            this.newSpeed = 0.0;
        } else if (this.newSpeed > 108.0) {
            this.newSpeed = 108.0;
        }
        if (this.newStorm) {
            this.newSpeed *= 1.5;
        } else if (this.newRain) {
            this.newSpeed *= 1.25;
        }
        this.newRotation = (lastRotation + this.getRotationEffect(rand.nextInt(1 + rand.nextInt(479)), rand.nextInt(5))) % 360.0f;
    }

    private float getRotationEffect(int newRotation, int type) {
        switch (type) {
            case 0: {
                return newRotation;
            }
            case 1: {
                return -newRotation;
            }
            case 2: {
                return 0.0f;
            }
            case 3: {
                return newRotation;
            }
            case 4: {
                return -newRotation;
            }
        }
        return 0.0f;
    }

    private int getSpeedEffect(int speed, int type) {
        switch (type) {
            case 0: {
                return speed;
            }
            case 1: {
                return -speed;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return speed;
            }
            case 4: {
                return -speed;
            }
        }
        return 0;
    }

    public boolean apply(RealisticWindProperty prop) {
        boolean done = true;
        if (prop.speed > this.newSpeed) {
            prop.speed -= 0.1;
            done = false;
        } else if (prop.speed < this.newSpeed) {
            prop.speed += 0.1;
            done = false;
        }
        if (prop.rotation > this.newRotation) {
            prop.rotation = (float)((double)prop.rotation - 0.1);
            done = false;
        } else if (prop.rotation < this.newRotation) {
            prop.rotation = (float)((double)prop.rotation + 0.1);
            done = false;
        }
        if (prop.yLevel > this.newYLevel) {
            --prop.yLevel;
            done = false;
        } else if (prop.yLevel < this.newYLevel) {
            ++prop.yLevel;
            done = false;
        }
        if (prop.thickness > this.newThickness) {
            --prop.thickness;
            done = false;
        } else if (prop.thickness < this.newThickness) {
            ++prop.thickness;
            done = false;
        }
        return done;
    }

    public void applyDifference(RealisticWindProperty prop) {
        prop.rain = this.newRain;
        prop.storm = this.newStorm;
        prop.maxTimeLeft = this.newMaxTimeLeft;
    }
}

