/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.math.Vec3d;

public class MathUtil {
    public static int[] fromIntegerToInt(Collection<Integer> key) {
        int[] result = new int[key.size()];
        int slot = 0;
        for (Integer entry : key) {
            result[slot++] = entry;
        }
        return result;
    }

    public static List<Integer> fromIntToInteger(int[] array) {
        ArrayList<Integer> result = new ArrayList<Integer>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.add(array[i]);
        }
        return result;
    }

    public static boolean[] flagsFromNumber(int size, int initialNumber) {
        boolean[] flags = new boolean[size];
        for (int i = 0; i < size; ++i) {
            flags[i] = (initialNumber & 1 << i) != 0;
        }
        return flags;
    }

    public static int[] fromTo(int min, int max) {
        if (min >= max) {
            return new int[0];
        }
        int limit = max - min;
        int[] array = new int[limit];
        for (int i = 0; i < limit; ++i) {
            array[i] = min + i;
        }
        return array;
    }

    public static List<Integer> fromToList(int min, int max) {
        if (min >= max) {
            return new ArrayList<Integer>();
        }
        int limit = max - min;
        ArrayList<Integer> result = new ArrayList<Integer>(limit);
        for (int i = 0; i < limit; ++i) {
            result.add(min + i);
        }
        return result;
    }

    public static int createValue(int totalValue, int amount, int max) {
        double result = (double)amount / (double)totalValue;
        return (int)(result * (double)max);
    }

    public static Vec3d substract(Vec3d pos, float distance) {
        return new Vec3d(pos.field_72450_a / (double)distance, pos.field_72448_b / (double)distance, pos.field_72449_c / (double)distance);
    }
}

