/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateNBTShapeCard
implements IMessage {
    private TypedMap args;

    public void fromBytes(ByteBuf buf) {
        this.args = TypedMapTools.readArguments((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        TypedMapTools.writeArguments((ByteBuf)buf, (TypedMap)this.args);
    }

    public PacketUpdateNBTShapeCard() {
    }

    public PacketUpdateNBTShapeCard(TypedMap arguments) {
        this.args = arguments;
    }

    public static class Handler
    implements IMessageHandler<PacketUpdateNBTShapeCard, IMessage> {
        public IMessage onMessage(PacketUpdateNBTShapeCard message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketUpdateNBTShapeCard message, MessageContext ctx) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            ItemStack heldItem = playerEntity.func_184586_b(EnumHand.MAIN_HAND);
            if (heldItem.func_190926_b()) {
                return;
            }
            NBTTagCompound tagCompound = heldItem.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
                heldItem.func_77982_d(tagCompound);
            }
            for (Key akey : message.args.getKeys()) {
                String key = akey.getName();
                if (Type.STRING.equals(akey.getType())) {
                    tagCompound.func_74778_a(key, (String)message.args.get(akey));
                    continue;
                }
                if (Type.INTEGER.equals(akey.getType())) {
                    tagCompound.func_74768_a(key, ((Integer)message.args.get(akey)).intValue());
                    continue;
                }
                if (Type.DOUBLE.equals(akey.getType())) {
                    tagCompound.func_74780_a(key, ((Double)message.args.get(akey)).doubleValue());
                    continue;
                }
                if (Type.BOOLEAN.equals(akey.getType())) {
                    tagCompound.func_74757_a(key, ((Boolean)message.args.get(akey)).booleanValue());
                    continue;
                }
                if (Type.BLOCKPOS.equals(akey.getType())) {
                    throw new RuntimeException("BlockPos not supported for PacketUpdateNBTItem!");
                }
                if (!Type.ITEMSTACK.equals(akey.getType())) continue;
                throw new RuntimeException("ItemStack not supported for PacketUpdateNBTItem!");
            }
        }
    }
}

