/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.util;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import omtteam.omlib.handler.ConfigHandler;

public class Player {
    private final UUID uuid;
    private String name;

    public Player(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public static void writeToByteBuf(Player player, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)player.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)player.getUuid().toString());
    }

    public static Player readFromByteBuf(ByteBuf buf) {
        String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        UUID uuid = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        return new Player(uuid, name);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Player player = (Player)o;
        return !ConfigHandler.offlineModeSupport ? this.getUuid().equals(player.getUuid()) : this.getName().toLowerCase().equals(player.getName().toLowerCase());
    }

    public int hashCode() {
        int result = this.getUuid() != null ? this.getUuid().hashCode() : 0;
        result = 31 * result + this.getName().toLowerCase().hashCode();
        return result;
    }
}

