/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import extracells.api.IECTileEntity;
import extracells.container.fluid.ContainerFluidFiller;
import extracells.gridblock.ECFluidGridBlock;
import extracells.gui.fluid.GuiFluidFiller;
import extracells.network.IGuiProvider;
import extracells.tileentity.IListenerTile;
import extracells.tileentity.TileBase;
import extracells.util.AEUtils;
import extracells.util.FluidHelper;
import extracells.util.MachineSource;
import extracells.util.StorageChannels;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityFluidFiller
extends TileBase
implements IActionHost,
ICraftingProvider,
IECTileEntity,
IMEMonitorHandlerReceiver<IAEFluidStack>,
IListenerTile,
ITickable,
IGuiProvider {
    private ECFluidGridBlock gridBlock;
    private IGridNode node = null;
    List<Fluid> fluids = new ArrayList<Fluid>();
    public ItemStack containerItem = new ItemStack(Items.field_151133_ar);
    ItemStack returnStack = null;
    int ticksToFinish = 0;
    private boolean isFirstGetGridNode = true;
    private final Item encodedPattern = AEApi.instance().definitions().items().encodedPattern().maybeItem().orElse(null);
    HashMap<ICraftingPatternDetails, FluidStack> patternFluids = new HashMap();

    public TileEntityFluidFiller() {
        this.gridBlock = new ECFluidGridBlock(this);
    }

    @MENetworkEventSubscribe
    public void cellUpdate(MENetworkCellArrayUpdate event) {
        IStorageGrid storage = this.getStorageGrid();
        if (storage != null) {
            this.postChange((IBaseMonitor<IAEFluidStack>)storage.getInventory((IStorageChannel)StorageChannels.FLUID()), null, null);
        }
    }

    public IGridNode getActionableNode() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return null;
        }
        if (this.node == null) {
            this.node = AEApi.instance().grid().createGridNode((IGridBlock)this.gridBlock);
        }
        return this.node;
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.DENSE_SMART;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public IGridNode getGridNode(AEPartLocation location) {
        if (FMLCommonHandler.instance().getSide().isClient() && (this.field_145850_b == null || this.field_145850_b.field_72995_K)) {
            return null;
        }
        if (this.isFirstGetGridNode) {
            this.isFirstGetGridNode = false;
            this.getActionableNode().updateState();
            IStorageGrid storage = this.getStorageGrid();
            storage.getInventory((IStorageChannel)StorageChannels.FLUID()).addListener((IMEMonitorHandlerReceiver)this, null);
        }
        return this.node;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    private ItemStack getPattern(ItemStack emptyContainer, ItemStack filledContainer) {
        NBTTagList in = new NBTTagList();
        NBTTagList out = new NBTTagList();
        in.func_74742_a((NBTBase)emptyContainer.func_77955_b(new NBTTagCompound()));
        out.func_74742_a((NBTBase)filledContainer.func_77955_b(new NBTTagCompound()));
        NBTTagCompound itemTag = new NBTTagCompound();
        itemTag.func_74782_a("in", (NBTBase)in);
        itemTag.func_74782_a("out", (NBTBase)out);
        itemTag.func_74757_a("crafting", false);
        ItemStack pattern = new ItemStack(this.encodedPattern);
        pattern.func_77982_d(itemTag);
        return pattern;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    private IStorageGrid getStorageGrid() {
        this.node = this.getGridNode(AEPartLocation.INTERNAL);
        if (this.node == null) {
            return null;
        }
        IGrid grid = this.node.getGrid();
        if (grid == null) {
            return null;
        }
        return (IStorageGrid)grid.getCache(IStorageGrid.class);
    }

    public boolean isBusy() {
        return this.returnStack != null && !this.returnStack.func_190926_b();
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void onListUpdate() {
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, IActionSource actionSource) {
        ArrayList<Fluid> oldFluids = new ArrayList<Fluid>(this.fluids);
        boolean mustUpdate = false;
        this.fluids.clear();
        for (IAEFluidStack fluid : ((IMEMonitor)monitor).getStorageList()) {
            if (!oldFluids.contains(fluid.getFluid())) {
                mustUpdate = true;
            } else {
                oldFluids.remove(fluid.getFluid());
            }
            this.fluids.add(fluid.getFluid());
        }
        if ((!oldFluids.isEmpty() || mustUpdate) && this.getGridNode(AEPartLocation.INTERNAL) != null && this.getGridNode(AEPartLocation.INTERNAL).getGrid() != null) {
            this.getGridNode(AEPartLocation.INTERNAL).getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getGridNode(AEPartLocation.INTERNAL)));
        }
    }

    public void postUpdateEvent() {
        if (this.getGridNode(AEPartLocation.INTERNAL) != null && this.getGridNode(AEPartLocation.INTERNAL).getGrid() != null) {
            this.getGridNode(AEPartLocation.INTERNAL).getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getGridNode(AEPartLocation.INTERNAL)));
        }
    }

    @MENetworkEventSubscribe
    public void powerUpdate(MENetworkPowerStatusChange event) {
        IStorageGrid storage = this.getStorageGrid();
        if (storage != null) {
            this.postChange((IBaseMonitor<IAEFluidStack>)storage.getInventory((IStorageChannel)StorageChannels.FLUID()), null, null);
        }
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.patternFluids.clear();
        IStorageGrid storage = this.getStorageGrid();
        if (storage == null) {
            return;
        }
        IMEMonitor fluidStorage = storage.getInventory((IStorageChannel)StorageChannels.FLUID());
        for (IAEFluidStack fluidStack : fluidStorage.getStorageList()) {
            ItemStack pattern;
            ICraftingPatternItem patter;
            ICraftingPatternDetails details;
            Pair<Integer, ItemStack> filled;
            int maxCapacity;
            Fluid fluid = fluidStack.getFluid();
            if (fluid == null || (maxCapacity = FluidHelper.getCapacity(this.containerItem)) == 0 || (filled = FluidHelper.fillStack(this.containerItem.func_77946_l(), new FluidStack(fluid, maxCapacity))).getRight() == null || (details = (patter = (ICraftingPatternItem)(pattern = this.getPattern(this.containerItem, (ItemStack)filled.getRight())).func_77973_b()).getPatternForItem(pattern, this.field_145850_b)) == null) continue;
            this.patternFluids.put(details, new FluidStack(fluid, ((Integer)filled.getLeft()).intValue()));
            craftingTracker.addCraftingOption((ICraftingMedium)this, details);
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.returnStack != null && !this.returnStack.func_190926_b()) {
            return false;
        }
        ItemStack filled = patternDetails.getCondensedOutputs()[0].getDefinition();
        if (!this.patternFluids.containsKey(patternDetails)) {
            return false;
        }
        FluidStack fluid = this.patternFluids.get(patternDetails);
        IStorageGrid storage = this.getStorageGrid();
        if (storage == null || fluid == null) {
            return false;
        }
        IAEFluidStack fluidStack = AEUtils.createFluidStack(new FluidStack(fluid.getFluid(), FluidHelper.getCapacity(patternDetails.getCondensedInputs()[0].getDefinition())));
        IAEFluidStack extracted = (IAEFluidStack)storage.getInventory((IStorageChannel)StorageChannels.FLUID()).extractItems((IAEStack)fluidStack.copy(), Actionable.SIMULATE, (IActionSource)new MachineSource(this));
        if (extracted == null || extracted.getStackSize() != fluidStack.getStackSize()) {
            return false;
        }
        storage.getInventory((IStorageChannel)StorageChannels.FLUID()).extractItems((IAEStack)fluidStack, Actionable.MODULATE, (IActionSource)new MachineSource(this));
        this.returnStack = filled;
        this.ticksToFinish = 40;
        return true;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("container")) {
            this.containerItem = new ItemStack(tagCompound.func_74775_l("container"));
        } else if (tagCompound.func_74764_b("isContainerEmpty") && tagCompound.func_74767_n("isContainerEmpty")) {
            this.containerItem = null;
        }
        if (tagCompound.func_74764_b("return")) {
            this.returnStack = new ItemStack(tagCompound.func_74775_l("return"));
        } else if (tagCompound.func_74764_b("isReturnEmpty") && tagCompound.func_74767_n("isReturnEmpty")) {
            this.returnStack = null;
        }
        if (tagCompound.func_74764_b("time")) {
            this.ticksToFinish = tagCompound.func_74762_e("time");
        }
        if (this.func_145830_o()) {
            IGridNode node = this.getGridNode(AEPartLocation.INTERNAL);
            if (tagCompound.func_74764_b("nodes") && node != null) {
                node.loadFromNBT("node0", tagCompound.func_74775_l("nodes"));
                node.updateState();
            }
        }
    }

    @Override
    public void registerListener() {
        IStorageGrid storage = this.getStorageGrid();
        if (storage == null) {
            return;
        }
        IMEMonitor fluidInventory = storage.getInventory((IStorageChannel)StorageChannels.FLUID());
        this.postChange((IBaseMonitor<IAEFluidStack>)fluidInventory, null, null);
        fluidInventory.addListener((IMEMonitorHandlerReceiver)this, null);
    }

    @Override
    public void removeListener() {
        IStorageGrid storage = this.getStorageGrid();
        if (storage == null) {
            return;
        }
        IMEMonitor fluidInventory = storage.getInventory((IStorageChannel)StorageChannels.FLUID());
        fluidInventory.removeListener((IMEMonitorHandlerReceiver)this);
    }

    public void securityBreak() {
    }

    public void func_73660_a() {
        if (!this.func_145830_o()) {
            return;
        }
        if (this.ticksToFinish > 0) {
            --this.ticksToFinish;
        }
        if (this.ticksToFinish <= 0 && this.returnStack != null && !this.returnStack.func_190926_b()) {
            IAEItemStack nodAdded;
            IStorageGrid storage = this.getStorageGrid();
            if (storage == null) {
                return;
            }
            IAEItemStack toInject = (IAEItemStack)StorageChannels.ITEM().createStack((Object)this.returnStack);
            if (storage.getInventory((IStorageChannel)StorageChannels.ITEM()).canAccept((IAEStack)toInject.copy()) && (nodAdded = (IAEItemStack)storage.getInventory((IStorageChannel)StorageChannels.ITEM()).injectItems((IAEStack)toInject.copy(), Actionable.SIMULATE, (IActionSource)new MachineSource(this))) == null) {
                storage.getInventory((IStorageChannel)StorageChannels.ITEM()).injectItems((IAEStack)toInject, Actionable.MODULATE, (IActionSource)new MachineSource(this));
                this.returnStack = null;
            }
        }
    }

    @Override
    public void updateGrid(IGrid oldGrid, IGrid newGrid) {
        IStorageGrid storage;
        if (oldGrid != null && (storage = (IStorageGrid)oldGrid.getCache(IStorageGrid.class)) != null) {
            storage.getInventory((IStorageChannel)StorageChannels.FLUID()).removeListener((IMEMonitorHandlerReceiver)this);
        }
        if (newGrid != null && (storage = (IStorageGrid)newGrid.getCache(IStorageGrid.class)) != null) {
            storage.getInventory((IStorageChannel)StorageChannels.FLUID()).addListener((IMEMonitorHandlerReceiver)this, null);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.containerItem != null) {
            tagCompound.func_74782_a("container", (NBTBase)this.containerItem.func_77955_b(new NBTTagCompound()));
        } else {
            tagCompound.func_74757_a("isContainerEmpty", true);
        }
        if (this.returnStack != null && !this.returnStack.func_190926_b()) {
            tagCompound.func_74782_a("return", (NBTBase)this.returnStack.func_77955_b(new NBTTagCompound()));
        } else {
            tagCompound.func_74757_a("isReturnEmpty", true);
        }
        tagCompound.func_74768_a("time", this.ticksToFinish);
        if (!this.func_145830_o()) {
            return tagCompound;
        }
        IGridNode node = this.getGridNode(AEPartLocation.INTERNAL);
        if (node != null) {
            NBTTagCompound nodeTag = new NBTTagCompound();
            node.saveToNBT("node0", nodeTag);
            tagCompound.func_74782_a("nodes", (NBTBase)nodeTag);
        }
        return tagCompound;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiFluidFiller(player, this);
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerFluidFiller(player.field_71071_by, this);
    }
}

