/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.turbine.tile;

import java.util.ArrayList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.tile.TileTurbineDynamoCoil;
import nc.multiblock.turbine.tile.TileTurbinePartBase;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class TileTurbineComputerPort
extends TileTurbinePartBase
implements SimpleComponent {
    public TileTurbineComputerPort() {
        super(CuboidalPartPositionType.WALL);
    }

    @Override
    public void onMachineAssembled(Turbine controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "nc_turbine";
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isComplete(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isHeatExchangerOn(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).isTurbineOn : false};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthX(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).getInteriorLengthX() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthY(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).getInteriorLengthY() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthZ(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).getInteriorLengthZ() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isProcessing(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).isProcessing : false};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyStored(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).energyStorage.getEnergyStored() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyCapacity(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).energyStorage.getMaxEnergyStored() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getPower(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).power : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getCoilConductivity(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).getEffectiveConductivity() : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFlowDirection(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() && ((Turbine)this.getMultiblock()).flowDir != null ? ((Turbine)this.getMultiblock()).flowDir.func_176610_l() : "null"};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getTotalExpansionLevel(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).totalExpansionLevel : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getIdealTotalExpansionLevel(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).idealTotalExpansionLevel : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getExpansionLevels(Context context, Arguments args) {
        return this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).expansionLevels.toArray() : new Object[]{};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getIdealExpansionLevels(Context context, Arguments args) {
        return this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).getIdealExpansionLevels().toArray() : new Object[]{};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getBladeEfficiencies(Context context, Arguments args) {
        return this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).rawBladeEfficiencies.toArray() : new Object[]{};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getInputRate(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).getActualInputRate() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getNumberOfDynamoCoils(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).getDynamoCoils().size() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getDynamoCoilStats(Context context, Arguments args) {
        if (this.isMultiblockAssembled()) {
            ArrayList<Object[]> stats = new ArrayList<Object[]>();
            for (TileTurbineDynamoCoil dynamoCoil : ((Turbine)this.getMultiblock()).getDynamoCoils()) {
                stats.add(new Object[]{new Object[]{dynamoCoil.func_174877_v().func_177958_n(), dynamoCoil.func_174877_v().func_177956_o(), dynamoCoil.func_174877_v().func_177952_p()}, dynamoCoil.coilType.func_176610_l(), dynamoCoil.isInValidPosition});
            }
            return stats.toArray();
        }
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] activate(Context context, Arguments args) {
        if (this.isMultiblockAssembled()) {
            ((Turbine)this.getMultiblock()).computerActivated = true;
            ((Turbine)this.getMultiblock()).setIsTurbineOn();
        }
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] deactivate(Context context, Arguments args) {
        if (this.isMultiblockAssembled()) {
            ((Turbine)this.getMultiblock()).computerActivated = false;
            ((Turbine)this.getMultiblock()).setIsTurbineOn();
        }
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] clearAllFluids(Context context, Arguments args) {
        if (this.isMultiblockAssembled()) {
            ((Turbine)this.getMultiblock()).clearAllFluids();
        }
        return new Object[0];
    }
}

