/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import nc.config.NCConfig;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.RecipeHelper;
import nc.recipe.RecipeInfo;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energy.ITileEnergy;
import nc.tile.energy.TileEnergy;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.Tank;
import nc.util.EnergyHelper;
import nc.util.ItemStackHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class TileDecayGenerator
extends TileEnergy
implements IInterfaceable {
    Random rand = new Random();
    public int tickCount;
    public static final ProcessorRecipeHandler RECIPE_HANDLER = NCRecipes.decay_generator;
    protected RecipeInfo<ProcessorRecipe>[] recipes = new RecipeInfo[6];
    public static final double DEFAULT_LIFETIME = 1200.0 / (double)NCConfig.machine_update_rate;
    protected int generatorCount;

    public TileDecayGenerator() {
        super(TileDecayGenerator.maxPower(), ITileEnergy.energyConnectionAll(EnergyConnection.OUT));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.tickGenerator();
            if (this.generatorCount == 0) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    List<ItemStack> input = Arrays.asList(ItemStackHelper.blockStateToStack(this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a(side))));
                    if (this.recipes[side.func_176745_a()] != null && this.recipes[side.func_176745_a()].getRecipe().matchInputs(input, new ArrayList<Tank>()).matches()) continue;
                    this.recipes[side.func_176745_a()] = RECIPE_HANDLER.getRecipeInfoFromInputs(input, new ArrayList<Tank>());
                }
                this.getEnergyStorage().changeEnergyStored(this.getGenerated());
                this.getRadiationSource().setRadiationLevel(this.getRadiation());
            }
            this.pushEnergy();
        }
    }

    public void tickGenerator() {
        ++this.generatorCount;
        this.generatorCount %= NCConfig.machine_update_rate;
    }

    private static int maxPower() {
        int max = 0;
        List recipes = RECIPE_HANDLER.getRecipes();
        for (ProcessorRecipe recipe : recipes) {
            if (recipe == null) continue;
            max = Math.max(max, recipe.getDecayPower());
        }
        return 20 * max;
    }

    public int getGenerated() {
        int power = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            power += this.decayGen(side);
        }
        return power;
    }

    public double getRadiation() {
        double radiation = 0.0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.getDecayRecipeInfo(side) == null) continue;
            radiation += this.getDecayRecipeInfo(side).getRecipe().getDecayRadiation();
        }
        return radiation;
    }

    public int decayGen(EnumFacing side) {
        if (this.getDecayRecipeInfo(side) == null) {
            return 0;
        }
        ItemStack stack = this.getOutput(side);
        if (stack == null || stack.func_190926_b()) {
            return 0;
        }
        IBlockState block = ItemStackHelper.getBlockStateFromStack(stack);
        if (block == null) {
            return 0;
        }
        if (this.rand.nextDouble() * this.getRecipeLifetime(side) < 1.0) {
            this.func_145831_w().func_175656_a(this.func_174877_v().func_177972_a(side), block);
        }
        return this.getRecipePower(side);
    }

    @Override
    public int getEUSourceTier() {
        return EnergyHelper.getEUTier(TileDecayGenerator.maxPower());
    }

    @Override
    public int getEUSinkTier() {
        return 10;
    }

    public RecipeInfo<ProcessorRecipe> getDecayRecipeInfo(EnumFacing side) {
        return this.recipes[side.func_176745_a()];
    }

    public double getRecipeLifetime(EnumFacing side) {
        if (this.getDecayRecipeInfo(side) == null) {
            return DEFAULT_LIFETIME;
        }
        return this.getDecayRecipeInfo(side).getRecipe().getDecayLifetime();
    }

    public int getRecipePower(EnumFacing side) {
        if (this.getDecayRecipeInfo(side) == null) {
            return 0;
        }
        return this.getDecayRecipeInfo(side).getRecipe().getDecayPower();
    }

    public ItemStack getOutput(EnumFacing side) {
        if (this.getDecayRecipeInfo(side) == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack output = RecipeHelper.getItemStackFromIngredientList(this.getDecayRecipeInfo(side).getRecipe().itemProducts(), 0);
        if (output != null) {
            return output;
        }
        return ItemStack.field_190927_a;
    }
}

