/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.util.math.MathHelper;

public class NCMath {
    private static Random rand = new Random();

    public static int square(int number) {
        return number * number;
    }

    public static double square(double number) {
        return number * number;
    }

    public static int cube(int number) {
        return number * number * number;
    }

    public static double cube(double number) {
        return number * number * number;
    }

    public static double round(double value, int precision) {
        double scale = Math.pow(10.0, precision);
        return (double)Math.round(value * scale) / (double)Math.round(scale);
    }

    public static int kroneckerDelta(int ... indices) {
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] == indices[(i + 1) % indices.length]) continue;
            return 0;
        }
        return 1;
    }

    public static double[] cartesianFromSpherical(double r, double theta, double phi) {
        return new double[]{r * Math.sin(theta * Math.PI / 180.0) * Math.cos(phi * Math.PI / 180.0), r * Math.sin(theta * Math.PI / 180.0) * Math.sin(phi * Math.PI / 180.0), r * Math.cos(theta * Math.PI / 180.0)};
    }

    public static int magnitudeMult(int in, int power) {
        double doubleOut = 1.0 * (double)in * Math.pow(10.0, 1.0 * (double)power);
        double roundedOut = Math.round(doubleOut);
        return (int)roundedOut;
    }

    public static long magnitudeMult(long in, int power) {
        double doubleOut = 1.0 * (double)in * Math.pow(10.0, 1.0 * (double)power);
        double roundedOut = Math.round(doubleOut);
        return (long)roundedOut;
    }

    public static double magnitudeMult(double in, int power) {
        return 1.0 * in * Math.pow(10.0, 1.0 * (double)power);
    }

    public static boolean atIntLimit(int number, int divider) {
        return Math.abs(number) > Integer.MAX_VALUE / divider;
    }

    public static boolean atLongLimit(long number, long divider) {
        return Math.abs(number) > Long.MAX_VALUE / divider;
    }

    public static boolean atDoubleLimit(double number, double divider) {
        return Math.abs(number) > Double.MAX_VALUE / divider;
    }

    public static int numberLength(long number) {
        return String.valueOf(number).length();
    }

    public static int minus1Power(int pow) {
        return (pow & 1) == 0 ? 1 : -1;
    }

    public static int choose(int n, int k) {
        if (n == k) {
            return 1;
        }
        if (n < k) {
            return NCMath.minus1Power(k) * NCMath.choose(k - n - 1, k);
        }
        if (k > n - k) {
            k = n - k;
        }
        double x = 1.0;
        int i = 1;
        int m = n;
        while (i <= k) {
            x *= (double)m / (double)i;
            ++i;
            --m;
        }
        return (int)Math.round(x);
    }

    public static int simplexNumber(int n, int p) {
        return NCMath.choose(n + p - 1, p);
    }

    public static int floorTo(int x, int mult) {
        return mult * MathHelper.func_76128_c((double)(1.0 * (double)x / (double)mult));
    }

    public static int ceilTo(int x, int mult) {
        return mult * MathHelper.func_76143_f((double)(1.0 * (double)x / (double)mult));
    }

    public static int roundTo(int x, int mult) {
        return mult * (int)Math.round(1.0 * (double)x / (double)mult);
    }

    public static double roundTo(double x, double mult) {
        return mult * (double)Math.round(x / mult);
    }

    public static int getBinomial(int n, double p) {
        int x = 0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.random() < p)) continue;
            ++x;
        }
        return x;
    }

    public static int getBinomial(int n, int p) {
        int x = 0;
        for (int i = 0; i < n; ++i) {
            if (rand.nextInt(100) >= p) continue;
            ++x;
        }
        return x;
    }

    public static int highestCommonFactor(int a, int b) {
        if (b == 0) {
            return a;
        }
        return NCMath.highestCommonFactor(b, a % b);
    }

    public static int lowestCommonMultiple(int a, int b) {
        return Math.abs(a * b) / NCMath.highestCommonFactor(a, b);
    }

    public static int hollowCube(int length) {
        return NCMath.cube(length) - NCMath.cube(length - 2);
    }

    public static double trapezoidalWave(double degs, double phase) {
        double angle = degs %= 360.0;
        if ((angle = (angle + phase) % 360.0) <= 60.0) {
            return 1.0;
        }
        if (angle <= 120.0) {
            return (120.0 - angle) / 60.0;
        }
        if (angle <= 240.0) {
            return 0.0;
        }
        if (angle <= 300.0) {
            return (angle - 240.0) / 60.0;
        }
        return 1.0;
    }

    public static String sigFigs(double number, int sigFigs) {
        if (number == (double)((int)number)) {
            return (int)number + "";
        }
        BigDecimal bd = new BigDecimal(number);
        bd = bd.round(new MathContext(Math.max(1, sigFigs)));
        return bd.doubleValue() + "";
    }

    public static String decimalPlaces(double number, int sigFigs) {
        if (number == (double)((int)number)) {
            return (int)number + "";
        }
        char[] arr = new char[Math.max(1, sigFigs)];
        Arrays.fill(arr, '#');
        DecimalFormat df = new DecimalFormat("0." + new String(arr));
        return df.format(number);
    }
}

