/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.command;

import com.universeguard.UniverseGuard;
import com.universeguard.region.LocalRegion;
import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionRole;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.InventoryUtils;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;

public class RegionBuyExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (src instanceof Player) {
            Player player = (Player)src;
            if (args.hasAny("region")) {
                Region region = RegionUtils.load((String)args.getOne("region").get());
                if (UniverseGuard.PURCHASABLE_REGIONS && region != null) {
                    LocalRegion localRegion = (LocalRegion)region;
                    if (!UniverseGuard.UNIQUE_REGIONS && RegionUtils.getPlayerRegions(player.getUniqueId()).size() < RegionUtils.getPlayerMaxRegions(player.getUniqueId())) {
                        ItemStack regionStack = ItemStack.of((ItemType)localRegion.getValue().getItem(), (int)localRegion.getValue().getQuantity());
                        if (player.getInventory().contains(regionStack) && InventoryUtils.removeFromInventory(player, regionStack)) {
                            RegionRole role = localRegion.getMembers().size() == 0 ? RegionRole.OWNER : RegionRole.MEMBER;
                            localRegion.addMember(player, role);
                            localRegion.setSold(true);
                            if (RegionUtils.save(localRegion)) {
                                MessageUtils.sendSuccessMessage(src, RegionText.REGION_BUYED.getValue());
                            } else {
                                MessageUtils.sendErrorMessage(src, RegionText.REGION_SAVE_EXCEPTION.getValue());
                            }
                        } else {
                            MessageUtils.sendErrorMessage(src, RegionText.TEXT_INVALID_BUY.getValue());
                        }
                    } else {
                        MessageUtils.sendErrorMessage(src, RegionText.PLAYERS_MAX_REGIONS.getValue());
                    }
                } else {
                    MessageUtils.sendErrorMessage(src, RegionText.NO_REGIONS_SELLED.getValue());
                }
            } else {
                MessageUtils.sendErrorMessage(src, this.getCommandUsage());
            }
        }
        return CommandResult.empty();
    }

    private String getCommandUsage() {
        return "/rg buy <region>";
    }
}

