/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.crafting;

import appeng.api.util.AEColor;
import appeng.block.crafting.BlockCraftingMonitor;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.client.render.crafting.CraftingCubeBakedModel;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

class MonitorBakedModel
extends CraftingCubeBakedModel {
    private final TextureAtlasSprite chassisTexture;
    private final TextureAtlasSprite baseTexture;
    private final TextureAtlasSprite lightDarkTexture;
    private final TextureAtlasSprite lightMediumTexture;
    private final TextureAtlasSprite lightBrightTexture;

    MonitorBakedModel(VertexFormat format, TextureAtlasSprite ringCorner, TextureAtlasSprite ringHor, TextureAtlasSprite ringVer, TextureAtlasSprite chassisTexture, TextureAtlasSprite baseTexture, TextureAtlasSprite lightDarkTexture, TextureAtlasSprite lightMediumTexture, TextureAtlasSprite lightBrightTexture) {
        super(format, ringCorner, ringHor, ringVer);
        this.chassisTexture = chassisTexture;
        this.baseTexture = baseTexture;
        this.lightDarkTexture = lightDarkTexture;
        this.lightMediumTexture = lightMediumTexture;
        this.lightBrightTexture = lightBrightTexture;
    }

    @Override
    protected void addInnerCube(EnumFacing side, IBlockState state, CubeBuilder builder, float x1, float y1, float z1, float x2, float y2, float z2) {
        EnumFacing forward = MonitorBakedModel.getForward(state);
        if (side != forward) {
            builder.setTexture(this.chassisTexture);
            builder.addCube(x1, y1, z1, x2, y2, z2);
            return;
        }
        builder.setTexture(this.baseTexture);
        builder.addCube(x1, y1, z1, x2, y2, z2);
        AEColor color = MonitorBakedModel.getColor(state);
        boolean powered = (Boolean)state.func_177229_b((IProperty)BlockCraftingMonitor.POWERED);
        builder.setRenderFullBright(powered);
        builder.setColorRGB(color.whiteVariant);
        builder.setTexture(this.lightBrightTexture);
        builder.addCube(x1, y1, z1, x2, y2, z2);
        builder.setColorRGB(color.mediumVariant);
        builder.setTexture(this.lightMediumTexture);
        builder.addCube(x1, y1, z1, x2, y2, z2);
        builder.setColorRGB(color.blackVariant);
        builder.setTexture(this.lightDarkTexture);
        builder.addCube(x1, y1, z1, x2, y2, z2);
    }

    private static AEColor getColor(IBlockState state) {
        IExtendedBlockState extState;
        AEColor color;
        if (state instanceof IExtendedBlockState && (color = (AEColor)((Object)(extState = (IExtendedBlockState)state).getValue(BlockCraftingMonitor.COLOR))) != null) {
            return color;
        }
        return AEColor.TRANSPARENT;
    }

    private static EnumFacing getForward(IBlockState state) {
        IExtendedBlockState extState;
        EnumFacing forward;
        if (state instanceof IExtendedBlockState && (forward = (EnumFacing)(extState = (IExtendedBlockState)state).getValue((IUnlistedProperty)BlockCraftingMonitor.FORWARD)) != null) {
            return forward;
        }
        return EnumFacing.NORTH;
    }
}

