/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.features.IGrinderRecipe;
import java.awt.Color;
import java.util.ArrayList;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;

class GrinderRecipeWrapper
implements IRecipeWrapper {
    private final IGrinderRecipe recipe;

    GrinderRecipeWrapper(IGrinderRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(ItemStack.class, (Object)this.recipe.getInput());
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(3);
        outputs.add(this.recipe.getOutput());
        this.recipe.getOptionalOutput().ifPresent(outputs::add);
        this.recipe.getSecondOptionalOutput().ifPresent(outputs::add);
        ingredients.setOutputs(ItemStack.class, outputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int xScaled;
        float width;
        String text;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int x = 118;
        float scale = 0.85f;
        float invScale = 1.1764705f;
        GlStateManager.func_179152_a((float)0.85f, (float)0.85f, (float)1.0f);
        if (this.recipe.getOptionalOutput() != null) {
            text = String.format("%d%%", (int)(this.recipe.getOptionalChance() * 100.0f));
            width = (float)fr.func_78256_a(text) * 0.85f;
            xScaled = Math.round(((float)x + (18.0f - width) / 2.0f) * 1.1764705f);
            fr.func_78276_b(text, xScaled, 76, Color.gray.getRGB());
            x += 18;
        }
        if (this.recipe.getSecondOptionalOutput() != null) {
            text = String.format("%d%%", (int)(this.recipe.getSecondOptionalChance() * 100.0f));
            width = (float)fr.func_78256_a(text) * 0.85f;
            xScaled = Math.round(((float)x + (18.0f - width) / 2.0f) * 1.1764705f);
            fr.func_78276_b(text, xScaled, 76, Color.gray.getRGB());
        }
        GlStateManager.func_179152_a((float)1.1764705f, (float)1.1764705f, (float)1.0f);
    }
}

