/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.prefab.entities;

import galaxyspace.GalaxySpace;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.BlockAdvancedLandingPadFull;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvLandingPad;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.event.EventLandingPadRemoval;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class EntityTier5Rocket
extends EntityTieredRocket {
    public EntityTier5Rocket(World par1World) {
        super(par1World);
        this.func_70105_a(2.2f, 11.0f);
    }

    public EntityTier5Rocket(World par1World, double par2, double par4, double par6, IRocketType.EnumRocketType rocketType) {
        super(par1World, par2, par4, par6);
        this.rocketType = rocketType;
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public EntityTier5Rocket(World par1World, double par2, double par4, double par6, boolean reversed, IRocketType.EnumRocketType rocketType, NonNullList<ItemStack> inv) {
        this(par1World, par2, par4, par6, rocketType);
        this.stacks = inv;
    }

    public double func_70033_W() {
        return 1.5;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(GSItems.ROCKET_TIER_5, 1, this.rocketType.getIndex());
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public double func_70042_X() {
        return 0.75;
    }

    public float getRotateOffset() {
        return 2.25f;
    }

    public double getOnPadYOffset() {
        return 0.0;
    }

    public void onLaunch() {
        super.onLaunch();
        if (!this.field_70170_p.field_72995_K) {
            GCPlayerStats stats = null;
            if (!this.func_184188_bt().isEmpty()) {
                for (Entity player : this.func_184188_bt()) {
                    if (!(player instanceof EntityPlayerMP)) continue;
                    stats = GCPlayerStats.get((Entity)player);
                    stats.setLaunchpadStack(null);
                    if (this.field_70170_p.field_73011_w instanceof IOrbitDimension) continue;
                    stats.setCoordsTeleportedFromX(player.field_70165_t);
                    stats.setCoordsTeleportedFromZ(player.field_70161_v);
                }
                Entity playerMain = (Entity)this.func_184188_bt().get(0);
                if (playerMain instanceof EntityPlayerMP) {
                    stats = GCPlayerStats.get((Entity)playerMain);
                }
            }
            int amountRemoved = 0;
            block1: for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 2; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 2; ++x) {
                for (int y = MathHelper.func_76128_c((double)this.field_70163_u) - 3; y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                    for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 2; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 2; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
                        if (block == null || !(block instanceof BlockAdvancedLandingPadFull) || amountRemoved >= 25) continue;
                        EventLandingPadRemoval event = new EventLandingPadRemoval(this.field_70170_p, pos);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.allow) break block1;
                        this.field_70170_p.func_175698_g(pos);
                        amountRemoved = 25;
                        break block1;
                    }
                }
            }
            if (stats != null && amountRemoved == 25) {
                stats.setLaunchpadStack(new ItemStack(GSBlocks.ADVANCED_LANDING_PAD_SINGLE, 25, 0));
            }
            this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getLaunched());
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && this.hasValidFuel() && this.field_70146_Z.nextInt(4) == 0 && !this.getLaunched()) {
            GalaxySpace.proxy.spawnParticle("waterbubbles", new Vector3(this.field_70165_t + 0.4 + this.field_70146_Z.nextDouble(), this.field_70163_u - 0.4 + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble()), new Vector3(0.11, -0.5, -0.03), new Object[]{20, 5, false, new Vector3(1.0), 1.0});
            GalaxySpace.proxy.spawnParticle("waterbubbles", new Vector3(this.field_70165_t - 0.8 + this.field_70146_Z.nextDouble(), this.field_70163_u - 0.4 + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble()), new Vector3(-0.2, -0.5, -0.03), new Object[]{20, 5, false, new Vector3(1.0), 1.0});
            GalaxySpace.proxy.spawnParticle("waterbubbles", new Vector3(this.field_70165_t - 0.2 + this.field_70146_Z.nextDouble(), this.field_70163_u - 0.4 + this.field_70146_Z.nextDouble(), this.field_70161_v + 0.4 + this.field_70146_Z.nextDouble()), new Vector3(0.0, -0.5, 0.16), new Object[]{20, 5, false, new Vector3(1.0), 1.0});
            GalaxySpace.proxy.spawnParticle("waterbubbles", new Vector3(this.field_70165_t - 0.2 + this.field_70146_Z.nextDouble(), this.field_70163_u - 0.4 + this.field_70146_Z.nextDouble(), this.field_70161_v - 0.4 + this.field_70146_Z.nextDouble()), new Vector3(0.0, -0.5, -0.16), new Object[]{20, 5, false, new Vector3(1.0), 1.0});
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel()) {
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
                double d = this.timeSinceLaunch / 150.0f;
                d = this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).hasNoAtmosphere() ? Math.min(d * 1.2, 2.0) : Math.min(d, 1.4);
                if (d != 0.0) {
                    this.field_70181_x = -d * 2.5 * Math.cos((this.field_70125_A - 180.0f) / 57.295776f);
                }
            } else {
                this.field_70181_x -= 0.008;
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(2.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(2);
                if (!this.hasValidFuel()) {
                    this.stopRocketSound();
                }
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && !this.field_70170_p.field_72995_K && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
    }

    public void onTeleport(EntityPlayerMP player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase != null) {
            GCPlayerStats stats = GCPlayerStats.get((Entity)playerBase);
            if (this.stacks == null || this.stacks.isEmpty()) {
                stats.setRocketStacks(NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a));
            } else {
                stats.setRocketStacks(this.stacks);
            }
            stats.setRocketType(this.rocketType.getIndex());
            stats.setRocketItem(GSItems.ROCKET_TIER_5);
            stats.setFuelLevel(this.fuelTank.getFluidAmount());
        }
    }

    protected void spawnParticles(boolean launched) {
        if (!this.field_70128_L) {
            double sinPitch = Math.sin((double)this.field_70125_A / 57.29577951308232);
            double x1 = 3.2 * Math.cos((double)this.field_70177_z / 57.29577951308232) * sinPitch;
            double z1 = 3.2 * Math.sin((double)this.field_70177_z / 57.29577951308232) * sinPitch;
            double y1 = 3.2 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.29577951308232);
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && this.targetVec != null) {
                double modifier = this.field_70163_u - (double)this.targetVec.func_177956_o();
                modifier = Math.max(modifier, 180.0);
                x1 *= modifier / 200.0;
                y1 *= Math.min(modifier / 200.0, 2.5);
                z1 *= modifier / 200.0;
            }
            double y2 = this.field_70167_r + (this.field_70163_u - this.field_70167_r) + y1 - 0.75 * this.field_70181_x - 0.3 + 1.2;
            double x2 = this.field_70165_t + x1 + this.field_70159_w;
            double z2 = this.field_70161_v + z1 + this.field_70179_y;
            Vector3 motionVec = new Vector3(x1 + this.field_70159_w, y1 + this.field_70181_x, z1 + this.field_70179_y);
            Vector3 d1 = new Vector3(y1 * 0.1, -x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d2 = new Vector3(x1 * 0.1, -z1 * 0.1, y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d3 = new Vector3(-y1 * 0.1, x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d4 = new Vector3(x1 * 0.1, z1 * 0.1, -y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d5 = new Vector3(y1 * 0.1, -x1 * 0.1, z1 * 0.1).rotate(270.0f - this.field_70177_z, motionVec);
            Vector3 d6 = new Vector3(x1 * 0.1, -z1 * 0.1, y1 * 0.1).rotate(270.0f - this.field_70177_z, motionVec);
            Vector3 d7 = new Vector3(-y1 * 0.1, x1 * 0.1, z1 * 0.1).rotate(270.0f - this.field_70177_z, motionVec);
            Vector3 d8 = new Vector3(x1 * 0.1, z1 * 0.1, -y1 * 0.1).rotate(270.0f - this.field_70177_z, motionVec);
            Vector3 mv1 = motionVec.clone().translate(d1);
            Vector3 mv2 = motionVec.clone().translate(d2);
            Vector3 mv3 = motionVec.clone().translate(d3);
            Vector3 mv4 = motionVec.clone().translate(d4);
            Vector3 mv5 = motionVec.clone().translate(d5);
            Vector3 mv6 = motionVec.clone().translate(d6);
            Vector3 mv7 = motionVec.clone().translate(d7);
            Vector3 mv8 = motionVec.clone().translate(d8);
            this.makeFlame(x2 + d1.x, y2 + d1.y, z2 + d1.z, mv1, this.getLaunched());
            this.makeFlame(x2 + d2.x, y2 + d2.y, z2 + d2.z, mv2, this.getLaunched());
            this.makeFlame(x2 + d3.x, y2 + d3.y, z2 + d3.z, mv3, this.getLaunched());
            this.makeFlame(x2 + d4.x, y2 + d4.y, z2 + d4.z, mv4, this.getLaunched());
            this.makeFlame(x2 + d5.x, y2 + d5.y, z2 + d5.z, mv5, this.getLaunched());
            this.makeFlame(x2 + d6.x, y2 + d6.y, z2 + d6.z, mv6, this.getLaunched());
            this.makeFlame(x2 + d7.x, y2 + d7.y, z2 + d7.z, mv7, this.getLaunched());
            this.makeFlame(x2 + d8.x, y2 + d8.y, z2 + d8.z, mv8, this.getLaunched());
            this.makeFlame(x2, y2, z2, new Vector3(x1, y1, z1), this.getLaunched());
        }
    }

    private void makeFlame(double x2, double y2, double z2, Vector3 motionVec, boolean getLaunched) {
        EntityLivingBase riddenByEntity;
        EntityLivingBase entityLivingBase = riddenByEntity = this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof EntityLivingBase) ? null : (EntityLivingBase)this.func_184188_bt().get(0);
        if (getLaunched) {
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4, y2, z2), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4, y2, z2), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 + 0.4), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 - 0.4), motionVec, new Object[]{riddenByEntity});
            return;
        }
        if (this.field_70173_aa % 2 == 0) {
            return;
        }
        double x1 = motionVec.x;
        double y1 = motionVec.y;
        double z1 = motionVec.z;
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2 += 1.6, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0), new Object[]{riddenByEntity});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0), new Object[]{riddenByEntity});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0), new Object[]{riddenByEntity});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0), new Object[]{riddenByEntity});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4, y2, z2), new Vector3(x1 + 0.3, y1 - 0.3, z1), new Object[]{riddenByEntity});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4, y2, z2), new Vector3(x1 - 0.3, y1 - 0.3, z1), new Object[]{riddenByEntity});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 + 0.4), new Vector3(x1, y1 - 0.3, z1 + 0.3), new Object[]{riddenByEntity});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 - 0.4), new Vector3(x1, y1 - 0.3, z1 - 0.3), new Object[]{riddenByEntity});
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return !this.field_70128_L && par1EntityPlayer.func_70068_e((Entity)this) <= 64.0;
    }

    protected void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
    }

    protected void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
    }

    public int getRocketTier() {
        return 5;
    }

    public int getFuelTankCapacity() {
        return 2800;
    }

    public int getPreLaunchWait() {
        return 400;
    }

    public float getCameraZoom() {
        return 15.0f;
    }

    public boolean defaultThirdPerson() {
        return true;
    }

    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItems) {
        super.getItemsDropped(droppedItems);
        ItemStack rocket = new ItemStack(GSItems.ROCKET_TIER_5, 1, this.rocketType.getIndex());
        rocket.func_77982_d(new NBTTagCompound());
        rocket.func_77978_p().func_74768_a("RocketFuel", this.fuelTank.getFluidAmount());
        droppedItems.add(rocket);
        return droppedItems;
    }

    public float getRenderOffsetY() {
        return -0.15f;
    }

    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof TileEntityAdvLandingPad;
    }

    public int addFuel(FluidStack liquid, boolean doFill) {
        return GSUtils.fillWithGCFuel(this.fuelTank, liquid, doFill, this);
    }
}

