/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.items.armor;

import galaxyspace.api.item.IJetpackArmor;
import galaxyspace.core.prefab.items.ItemElectricArmor;
import galaxyspace.core.util.GSCreativeTabs;
import galaxyspace.systems.SolarSystem.planets.overworld.items.armor.ItemSpaceSuit;
import galaxyspace.systems.SolarSystem.planets.overworld.render.item.ItemSpaceSuitModel;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.item.IItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemJetpack
extends ItemElectricArmor
implements ISpecialArmor,
IJetpackArmor {
    public ItemJetpack(ItemArmor.ArmorMaterial materialIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, equipmentSlotIn);
        this.func_77655_b("jetpack");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == GSCreativeTabs.GSArmorTab || tab == CreativeTabs.field_78027_g) {
            list.add((Object)new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped model) {
        ItemSpaceSuitModel armormodel = new ItemSpaceSuitModel(5);
        if (itemStack.func_77973_b() instanceof ItemJetpack) {
            armormodel = ItemSpaceSuit.fillingArmorModel(armormodel, entityLiving);
        }
        return armormodel;
    }

    @Override
    public float getMaxElectricityStored(ItemStack theItem) {
        return 100000.0f;
    }

    @Override
    public void consumeFuel(ItemStack stack, int fuel) {
        this.discharge(stack, 5.0f, true);
    }

    @Override
    public void decrementFuel(ItemStack stack) {
        if (stack.func_77973_b() instanceof IItemElectricBase) {
            ((IItemElectricBase)stack.func_77973_b()).discharge(stack, 1.0f, true);
        }
    }

    @Override
    public int getFuel(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("jetpack:fuel");
    }

    @Override
    public boolean canFly(ItemStack stack, EntityPlayer player) {
        return stack.func_77942_o() && stack.func_77952_i() < stack.func_77958_k();
    }

    @Override
    public boolean isActivated(ItemStack stack) {
        return stack.func_77978_p().func_74767_n("jetpack:activated");
    }

    @Override
    public void switchState(ItemStack stack, boolean state) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74757_a("jetpack:activated", state);
        } else {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    @Override
    public int getFireStreams(ItemStack stack) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flagIn) {
        String color = "";
        float joules = this.getElectricityStored(stack);
        color = joules <= this.getMaxElectricityStored(stack) / 3.0f ? "\u00a74" : (joules > this.getMaxElectricityStored(stack) * 2.0f / 3.0f ? "\u00a72" : "\u00a76");
        list.add("");
        list.add(color + EnergyDisplayHelper.getEnergyDisplayS((float)joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS((float)this.getMaxElectricityStored(stack)));
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 3070171;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        return new ISpecialArmor.ArmorProperties(2, 0.15, Integer.MAX_VALUE);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.field_77879_b;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        this.discharge(stack, 5.0f, true);
    }
}

