/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.activetime.commands.elements;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

public class FlagsElement
extends CommandElement {
    private final ImmutableMap<List<String>, CommandElement> flags;
    private final ImmutableMap<String, CommandElement> aliases;

    public FlagsElement(Map<List<String>, CommandElement> flags) {
        super(null);
        this.flags = ImmutableMap.copyOf(flags);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        flags.forEach((k, v) -> k.forEach(f -> builder.put((Object)("-" + f.toLowerCase()), v)));
        this.aliases = builder.build();
    }

    public void parse(CommandSource src, CommandArgs args, CommandContext ctx) throws ArgumentParseException {
        while (args.hasNext() && args.peek().startsWith("-")) {
            String[] split = args.next().split("=", 2);
            CommandElement element = (CommandElement)this.aliases.get((Object)split[0]);
            if (element == null) {
                throw args.createError(Text.of((Object[])new Object[]{"Unknown flag ", split[0], "."}));
            }
            if (split.length == 2) {
                args.insertArg(split[1]);
            }
            try {
                element.parse(src, args, ctx);
            }
            catch (ArgumentParseException e) {
                throw args.createError(Text.of((Object[])new Object[]{"Error parsing value for flag ", split[0], ": ", e.getText()}));
            }
        }
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> complete(CommandSource src, CommandArgs args, CommandContext ctx) {
        ArrayList unused = Lists.newArrayList((Iterable)this.flags.keySet());
        try {
            while (args.hasNext() && args.peek().startsWith("-")) {
                String[] split = args.next().split("=", 2);
                CommandElement element = (CommandElement)this.aliases.get((Object)split[0].toLowerCase());
                if (element == null || split.length == 1 && !args.hasNext()) {
                    return unused.stream().flatMap(Collection::stream).map(s -> "-" + s).filter(s -> s.toLowerCase().startsWith(split[0].toLowerCase())).collect(Collectors.toList());
                }
                if (split.length == 2) {
                    args.insertArg(split[1]);
                }
                Object state = args.getState();
                try {
                    element.parse(src, args, ctx);
                    unused.removeIf(l -> l.contains(split[0].substring(1).toLowerCase()));
                }
                catch (ArgumentParseException e) {
                    args.setState(state);
                    String start = split.length == 2 ? split[0] + "=" : "";
                    return element.complete(src, args, ctx).stream().map(s -> start + s).collect(Collectors.toList());
                    return args.nextIfPresent().map(String::toLowerCase).map(a -> unused.stream().flatMap(Collection::stream).map(s -> "-" + s).filter(s -> s.toLowerCase().startsWith((String)a)).collect(Collectors.toList())).orElse((List)ImmutableList.of());
                }
            }
        }
        catch (ArgumentParseException argumentParseException) {
            // empty catch block
        }
        return args.nextIfPresent().map(String::toLowerCase).map(a -> unused.stream().flatMap(Collection::stream).map(s -> "-" + s).filter(s -> s.toLowerCase().startsWith((String)a)).collect(Collectors.toList())).orElse((List)ImmutableList.of());
    }

    public Text getUsage(CommandSource src) {
        ArrayList args = Lists.newArrayList();
        for (Map.Entry entry : this.flags.entrySet()) {
            args.add("[" + String.join((CharSequence)"|", (Iterable)entry.getKey()));
            Text usage = ((CommandElement)entry.getValue()).getUsage(src);
            if (!usage.isEmpty()) {
                args.add(": ");
                args.add(usage);
            }
            args.add("] ");
        }
        return Text.of((Object[])args.toArray());
    }

    @Deprecated
    protected Object parseValue(CommandSource src, CommandArgs args) {
        throw new UnsupportedOperationException("Attempted to parse a value from flags.");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class MarkTrue
    extends CommandElement {
        public MarkTrue(String flag) {
            super((Text)Text.of((String)flag));
        }

        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return Boolean.TRUE;
        }

        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return ImmutableList.of();
        }

        public Text getUsage(CommandSource src) {
            return Text.EMPTY;
        }
    }

    public static class Builder {
        private Map<List<String>, CommandElement> flags = Maps.newHashMap();

        public Builder flag(CommandElement element, String ... flags) {
            this.flags.put(Arrays.stream(flags).map(String::toLowerCase).collect(Collectors.toList()), element);
            return this;
        }

        public Builder flag(String ... flags) {
            return flags.length != 0 ? this.flag(new MarkTrue(flags[0]), flags) : this;
        }

        public FlagsElement build() {
            return new FlagsElement(this.flags);
        }
    }
}

