/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.activetime.objects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mcsimonflash.sponge.activetime.managers.Storage;
import com.mcsimonflash.sponge.activetime.managers.Util;
import com.mcsimonflash.sponge.activetime.objects.TimeHolder;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.spongepowered.api.text.Text;

public class UserReport {
    public final UUID uuid;
    public final String name;
    public final LocalDate from;
    public final LocalDate to;
    public final TimeHolder total = new TimeHolder();
    public final TimeHolder dailyAverage = new TimeHolder();
    public final TimeHolder weeklyAverage = new TimeHolder();
    public final TimeHolder monthlyAverage = new TimeHolder();
    public final Map<LocalDate, TimeHolder> dailyTimes = Maps.newLinkedHashMap();
    public final Map<LocalDate, TimeHolder> weeklyTimes = Maps.newLinkedHashMap();
    public final Map<LocalDate, TimeHolder> monthlyTimes = Maps.newLinkedHashMap();
    public final List<Text> print = Lists.newArrayList();

    public UserReport(UUID uuid, LocalDate from, LocalDate to) {
        this.uuid = uuid;
        this.from = from;
        this.to = to;
        this.name = Storage.getUsername(uuid);
    }

    public UserReport generate() {
        if (this.dailyTimes.isEmpty()) {
            Storage.generateUserReport(this);
        }
        return this;
    }

    public List<Text> print() {
        if (this.print.isEmpty()) {
            this.print.add(Util.toText("Name: &b" + this.name));
            this.print.add(Util.toText("UUID: &b" + this.uuid));
            this.print.add(Util.toText("From: &b" + this.from));
            this.print.add(Util.toText("To: &b" + this.to));
            this.print.add(Util.toText("Total: " + Util.printTime(this.total)));
            this.print.add(Util.toText("Daily Average: " + Util.printTime(this.dailyAverage)));
            this.print.add(Util.toText("Weekly Average: " + Util.printTime(this.weeklyAverage)));
            this.print.add(Util.toText("Monthly Average: " + Util.printTime(this.monthlyAverage)));
            Util.addTimes(this.print, "Days: ", this.dailyTimes.entrySet(), Util::printDate);
            Util.addTimes(this.print, "Weeks: ", this.weeklyTimes.entrySet(), Util::printDate);
            Util.addTimes(this.print, "Months: ", this.monthlyTimes.entrySet(), Util::printDate);
        }
        return this.print;
    }
}

