/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab.inventory;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ISave;
import icbm.classic.prefab.inventory.InventoryUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class BasicInventory
implements ISave,
IInventory,
Iterable<Map.Entry<Integer, ItemStack>> {
    protected int slots;
    protected int shiftSlotStart = 0;
    protected boolean recalculateFillStatus = true;
    protected boolean isFull = false;
    protected HashMap<Integer, ItemStack> inventoryMap = new HashMap();
    public String inventoryName = "container.inventory.basic";
    protected boolean _loading = false;

    public BasicInventory(int slots) {
        this.slots = slots;
    }

    public int func_70302_i_() {
        return this.slots;
    }

    public Collection<ItemStack> getContainedItems() {
        return this.inventoryMap.values();
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= 0 && slot < this.func_70302_i_()) {
            return this.inventoryMap.containsKey(slot) ? this.inventoryMap.get(slot) : ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int slot, int ammount) {
        if (this.func_70301_a(slot) != null) {
            if (this.func_70301_a(slot).func_190916_E() <= ammount) {
                ItemStack var3 = this.func_70301_a(slot);
                this.func_70299_a(slot, ItemStack.field_190927_a);
                this.func_70296_d();
                return var3;
            }
            ItemStack var3 = this.func_70301_a(slot).func_77979_a(ammount);
            if (this.func_70301_a(slot).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return var3;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            this.func_70299_a(0, ItemStack.field_190927_a);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, ItemStack insertStack) {
        if (slot >= 0 && slot < this.func_70302_i_()) {
            ItemStack pre_stack;
            ItemStack itemStack = pre_stack = this.func_70301_a(slot) != null ? this.func_70301_a(slot).func_77946_l() : null;
            if (insertStack != ItemStack.field_190927_a) {
                this.inventoryMap.put(slot, insertStack);
            } else if (this.inventoryMap.containsKey(slot)) {
                this.inventoryMap.remove(slot);
            }
            if (!this._loading && !InventoryUtility.stacksMatchExact(pre_stack, this.func_70301_a(slot))) {
                this.recalculateFillStatus = true;
                this.onInventoryChanged(slot, pre_stack, this.func_70301_a(slot));
            }
        } else {
            ICBMClassic.logger().error("BasicInventory: something tried to set " + insertStack + " into slot " + slot + " which is outside the 0 - " + (this.func_70302_i_() - 1) + " limit");
        }
    }

    protected void onInventoryChanged(int slot, ItemStack prev, ItemStack item) {
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.inventoryName;
    }

    public BasicInventory setInventoryName(String name) {
        this.inventoryName = name;
        return this;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i >= this.func_70302_i_() && i < this.func_70302_i_();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return true;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this._loading = true;
        this.inventoryMap.clear();
        NBTTagList nbtList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound stackTag = nbtList.func_150305_b(i);
            byte id = stackTag.func_74771_c("Slot");
            if (id < 0 || id >= this.func_70302_i_()) continue;
            this.func_70299_a(id, new ItemStack(stackTag));
        }
        nbt.func_74782_a("Items", (NBTBase)nbtList);
        this._loading = false;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        NBTTagList nbtList = new NBTTagList();
        for (int i = this.shiftSlotStart; i < this.func_70302_i_() + this.shiftSlotStart; ++i) {
            if (this.func_70301_a(i + this.shiftSlotStart).func_190926_b()) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i + this.shiftSlotStart).func_77955_b(var4);
            nbtList.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)nbtList);
        return nbt;
    }

    public boolean func_191420_l() {
        return this.inventoryMap.isEmpty();
    }

    public boolean isFull() {
        if (this.recalculateFillStatus) {
            this.recalculateFillStatus = false;
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (this.roomLeftInSlot(i) <= 0) continue;
                this.isFull = false;
                return false;
            }
            this.isFull = true;
        }
        return this.isFull;
    }

    public ArrayList<Integer> getFilledSlots() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (this.func_70301_a(slot).func_190926_b()) continue;
            slots.add(slot);
        }
        return slots;
    }

    public ArrayList<Integer> getEmptySlots() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (!this.func_70301_a(slot).func_190926_b()) continue;
            slots.add(slot);
        }
        return slots;
    }

    public ArrayList<Integer> getSlotsWithSpace() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (this.roomLeftInSlot(slot) <= 0) continue;
            slots.add(slot);
        }
        return slots;
    }

    public int roomLeftInSlot(int slot) {
        if (!this.func_70301_a(slot).func_190926_b()) {
            int maxSpace = Math.min(this.func_70301_a(slot).func_77976_d(), this.func_70297_j_());
            return maxSpace - this.func_70301_a(slot).func_190916_E();
        }
        return this.func_70297_j_();
    }

    @Override
    public Iterator<Map.Entry<Integer, ItemStack>> iterator() {
        return this.inventoryMap.entrySet().iterator();
    }

    public String toString() {
        return "BasicInventory[" + this.func_70005_c_() + ", " + this.func_70302_i_() + "]@" + this.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BasicInventory) {
            return ((BasicInventory)object).slots == this.slots && ((BasicInventory)object).inventoryMap == this.inventoryMap;
        }
        return false;
    }

    public int hashCode() {
        return this.inventoryMap != null ? this.inventoryMap.hashCode() : super.hashCode();
    }
}

