/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.argumentparsers;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Kit;
import io.github.nucleuspowered.nucleus.internal.traits.PermissionTrait;
import io.github.nucleuspowered.nucleus.modules.kit.commands.kit.KitCommand;
import io.github.nucleuspowered.nucleus.modules.kit.config.KitConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.kit.services.KitHandler;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;

public class KitArgument
extends CommandElement
implements PermissionTrait {
    private final KitConfigAdapter config;
    private final KitHandler kitHandler;
    private final boolean permissionCheck;
    private final String showhiddenperm = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(KitCommand.class).getPermissionWithSuffix("showhidden");

    public KitArgument(@Nullable Text key, boolean permissionCheck) {
        super(key);
        this.config = Nucleus.getNucleus().getConfigAdapter("kit", KitConfigAdapter.class).get();
        this.kitHandler = Nucleus.getNucleus().getInternalServiceManager().getService(KitHandler.class).get();
        this.permissionCheck = permissionCheck;
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        String kitName = args.next();
        if (kitName.isEmpty()) {
            throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.kit.noname", new String[0]));
        }
        Kit kit = this.kitHandler.getKit(kitName).orElseThrow(() -> args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.kit.noexist", new String[0])));
        if (!this.checkPermission(source, kit)) {
            throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.kit.noperms", new String[0]));
        }
        return kit;
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        try {
            boolean showhidden = this.hasPermission((Subject)src, this.showhiddenperm);
            String name = args.peek().toLowerCase();
            return this.kitHandler.getKitNames().stream().filter(s -> s.toLowerCase().startsWith(name)).limit(20L).map(x -> this.kitHandler.getKit((String)x).get()).filter(x -> this.checkPermission(src, (Kit)x)).filter(x -> this.permissionCheck && (showhidden || !x.isHiddenFromList())).map(x -> x.getName().toLowerCase()).collect(Collectors.toList());
        }
        catch (ArgumentParseException e) {
            return Lists.newArrayList();
        }
    }

    private boolean checkPermission(CommandSource src, Kit kit) {
        if (!this.permissionCheck) {
            return true;
        }
        return this.hasPermission((Subject)src, "nucleus.kits." + kit.getName().toLowerCase());
    }
}

