/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.dataservices;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.configurate.datatypes.UserCacheDataNode;
import io.github.nucleuspowered.nucleus.configurate.datatypes.UserCacheVersionNode;
import io.github.nucleuspowered.nucleus.dataservices.AbstractService;
import io.github.nucleuspowered.nucleus.dataservices.dataproviders.DataProvider;
import io.github.nucleuspowered.nucleus.dataservices.loaders.UserDataManager;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.util.Identifiable;

public class UserCacheService
extends AbstractService<UserCacheVersionNode> {
    private static final int expectedVersion = new UserCacheVersionNode().getVersion();
    private boolean isWalking = false;
    private final Object lockingObject = new Object();

    public UserCacheService(DataProvider<UserCacheVersionNode> dataProvider) {
        super(dataProvider);
    }

    public List<UUID> getForIp(String ip) {
        this.updateCacheForOnlinePlayers();
        String ipToCheck = ip.replace("/", "");
        return ((UserCacheVersionNode)this.data).getNode().entrySet().stream().filter(x -> ((UserCacheDataNode)x.getValue()).getIpAddress().map(y -> y.equals(ipToCheck)).orElse(false)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public List<UUID> getJailed() {
        this.updateCacheForOnlinePlayers();
        return ((UserCacheVersionNode)this.data).getNode().entrySet().stream().filter(x -> ((UserCacheDataNode)x.getValue()).isJailed()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public List<UUID> getJailedIn(String name) {
        this.updateCacheForOnlinePlayers();
        return ((UserCacheVersionNode)this.data).getNode().entrySet().stream().filter(x -> ((UserCacheDataNode)x.getValue()).getJailName().map(y -> y.equalsIgnoreCase(name)).orElse(false)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public List<UUID> getMuted() {
        this.updateCacheForOnlinePlayers();
        return ((UserCacheVersionNode)this.data).getNode().entrySet().stream().filter(x -> ((UserCacheDataNode)x.getValue()).isMuted()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    protected String serviceName() {
        return "User Cache";
    }

    public void updateCacheForOnlinePlayers() {
        Nucleus.getNucleus().getUserDataManager().getOnlineUsers().forEach(u -> ((UserCacheVersionNode)this.data).getNode().computeIfAbsent(u.getUniqueId(), x -> new UserCacheDataNode()).set((ModularUserService)u));
    }

    public void updateCacheForPlayer(ModularUserService u) {
        ((UserCacheVersionNode)this.data).getNode().computeIfAbsent(u.getUniqueId(), x -> new UserCacheDataNode()).set(u);
    }

    public void updateCacheForPlayer(UUID uuid) {
        Nucleus.getNucleus().getUserDataManager().get(uuid).ifPresent(this::updateCacheForPlayer);
    }

    public void startFilewalkIfNeeded() {
        if (!(this.isWalking || this.isCorrectVersion() && !((UserCacheVersionNode)this.data).getNode().isEmpty())) {
            this.fileWalk();
        }
    }

    public boolean isCorrectVersion() {
        return expectedVersion == ((UserCacheVersionNode)this.data).getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fileWalk() {
        Object object = this.lockingObject;
        synchronized (object) {
            if (this.isWalking) {
                return false;
            }
            this.isWalking = true;
        }
        try {
            HashMap data = Maps.newHashMap();
            List knownUsers = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).getAll().stream().map(Identifiable::getUniqueId).collect(Collectors.toList());
            int count = 0;
            UserDataManager manager = Nucleus.getNucleus().getUserDataManager();
            for (UUID user : knownUsers) {
                if (!manager.has(user)) continue;
                manager.get(user).ifPresent(x -> data.put(user, new UserCacheDataNode((ModularUserService)x)));
                if (++count < 10) continue;
                manager.removeOfflinePlayers();
                count = 0;
            }
            this.data = new UserCacheVersionNode();
            ((UserCacheVersionNode)this.data).getNode().putAll(data);
            this.save();
        }
        finally {
            this.isWalking = false;
        }
        return true;
    }
}

