/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.docgen.generators;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.internal.docgen.CommandDoc;
import io.github.nucleuspowered.nucleus.internal.docgen.PermissionDoc;
import io.github.nucleuspowered.nucleus.internal.docgen.generators.MarkdownCreator;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class MarkdownGenerator<T> {
    private static final String EMPTY = "";

    abstract List<String> create(List<T> var1);

    public final void create(Path file, List<T> input) throws Exception {
        Files.write(file, this.create(input), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
    }

    private static PermissionDoc combine(String base, List<PermissionDoc> combine) {
        return new PermissionDoc().setDefaultLevel("ADMIN").setDescription("Exemption permissions").setModule(combine.get(0).getModule()).setPermission(base + "<" + combine.stream().map(x -> x.getPermission().replace(base, EMPTY)).collect(Collectors.joining("\\|")) + ">");
    }

    public static class PermissionMarkdownGenerator
    extends MarkdownGenerator<PermissionDoc> {
        @Override
        List<String> create(List<PermissionDoc> input) {
            input.stream().collect(Collectors.groupingBy(PermissionDoc::getPermission, Collectors.counting())).forEach((k, v) -> {
                if (v > 1L) {
                    System.out.println(k + ": " + v);
                }
            });
            Map<String, PermissionDoc> docs = input.stream().filter(x -> !x.getPermission().contains("colour")).collect(Collectors.toMap(PermissionDoc::getPermission, x -> x));
            ArrayList newDocs = Lists.newArrayList();
            List<PermissionDoc> endInBase = docs.entrySet().stream().filter(c -> ((String)c.getKey()).endsWith(".base")).map(Map.Entry::getValue).collect(Collectors.toList());
            endInBase.forEach(x -> x.setDescription(x.getDescription().replaceAll("Allows the user to run the command ", MarkdownGenerator.EMPTY)));
            endInBase.forEach(x -> {
                String perm = x.getPermission().replace(".base", MarkdownGenerator.EMPTY).concat(".exempt.");
                List<PermissionDoc> toProcess = docs.entrySet().stream().filter(y -> ((String)y.getKey()).startsWith(perm)).map(Map.Entry::getValue).collect(Collectors.toList());
                if (!toProcess.isEmpty()) {
                    PermissionDoc combine = MarkdownGenerator.combine(perm, toProcess);
                    toProcess.forEach(c -> {
                        PermissionDoc cfr_ignored_0 = (PermissionDoc)docs.remove(c.getPermission());
                    });
                    newDocs.add(combine);
                }
            });
            newDocs.addAll(docs.values());
            newDocs.sort(Comparator.comparing(PermissionDoc::getModule).thenComparing(PermissionDoc::getPermission));
            LinkedHashMap lhm = Maps.newLinkedHashMap();
            lhm.put("Module", PermissionDoc::getModule);
            lhm.put("Permission", PermissionDoc::getPermission);
            lhm.put("Description", t -> t.getDescription().replace("\n", " "));
            return MarkdownCreator.createTable(newDocs, lhm);
        }
    }

    public static class CommandMarkdownGenerator
    extends MarkdownGenerator<CommandDoc> {
        @Override
        List<String> create(List<CommandDoc> input) {
            ArrayList output = Lists.newArrayList();
            output.add("# Commands");
            output.add("This is a summary of commands available in Nucleus. You can also visit a searchable version: see https://nucleuspowered.org/docs/commands2.html");
            Map d = input.stream().collect(Collectors.groupingBy(CommandDoc::getModule, Collectors.toList()));
            ArrayList i = Lists.newArrayList(d.keySet());
            i.sort(String::compareToIgnoreCase);
            LinkedHashMap lhm = Maps.newLinkedHashMap();
            lhm.put("Command", t -> "`/" + t.getCommandName() + "`");
            lhm.put("Permission", x -> {
                if (!x.getPermissionbase().isEmpty()) {
                    return x.getPermissionbase().concat(".base");
                }
                return MarkdownGenerator.EMPTY;
            });
            lhm.put("Description", CommandDoc::getOneLineDescription);
            for (String mod : i) {
                output.add("## Module: " + mod);
                List dd = d.get(mod);
                dd.sort(Comparator.comparing(CommandDoc::getCommandName));
                output.addAll(MarkdownCreator.createTable(dd, lhm));
            }
            return output;
        }
    }
}

