/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.item.config.ItemConfig;
import io.github.nucleuspowered.nucleus.modules.item.config.ItemConfigAdapter;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.item.DurabilityData;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.entity.Hotbar;
import org.spongepowered.api.item.inventory.equipment.EquipmentInventory;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Permissions(supportsOthers=true)
@RegisterCommand(value={"repair", "mend"})
@EssentialsEquivalent(value={"repair", "fix"})
public class RepairCommand
extends AbstractCommand<Player>
implements Reloadable {
    private boolean whitelist = false;
    private List<ItemType> restrictions = new ArrayList<ItemType>();

    @Override
    public void onReload() {
        this.whitelist = ((ItemConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(ItemConfigAdapter.class).getNodeOrDefault()).getRepairConfig().isWhitelist();
        this.restrictions = ((ItemConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(ItemConfigAdapter.class).getNodeOrDefault()).getRepairConfig().getRestrictions();
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"m", "-mainhand"}).permissionFlag(this.permissions.getPermissionWithSuffix("flag.all"), new String[]{"a", "-all"}).permissionFlag(this.permissions.getPermissionWithSuffix("flag.hotbar"), new String[]{"h", "-hotbar"}).permissionFlag(this.permissions.getPermissionWithSuffix("flag.equip"), new String[]{"e", "-equip"}).permissionFlag(this.permissions.getPermissionWithSuffix("flag.offhand"), new String[]{"o", "-offhand"}).buildWith(GenericArguments.none())};
    }

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        Map<String, PermissionInformation> mspi = super.permissionSuffixesToRegister();
        mspi.put("flag.all", PermissionInformation.getWithTranslation("permission.repair.flag.all", SuggestedLevel.ADMIN));
        mspi.put("flag.hotbar", PermissionInformation.getWithTranslation("permission.repair.flag.hotbar", SuggestedLevel.ADMIN));
        mspi.put("flag.equip", PermissionInformation.getWithTranslation("permission.repair.flag.equip", SuggestedLevel.ADMIN));
        mspi.put("flag.offhand", PermissionInformation.getWithTranslation("permission.repair.flag.offhand", SuggestedLevel.ADMIN));
        return mspi;
    }

    @Override
    protected CommandResult executeCommand(Player pl, CommandContext args, Cause cause) throws Exception {
        EnumMap<ResultType, Integer> resultCount = new EnumMap<ResultType, Integer>(ResultType.class){
            {
                this.put(ResultType.SUCCESS, 0);
                this.put(ResultType.ERROR, 0);
                this.put(ResultType.NO_DURABILITY, 0);
                this.put(ResultType.RESTRICTED, 0);
            }
        };
        EnumMap<ResultType, ItemStackSnapshot> lastItem = new EnumMap<ResultType, ItemStackSnapshot>(ResultType.class);
        boolean checkRestrictions = !this.hasPermission((Subject)pl, this.permissions.getPermissionWithSuffix("exempt.restriction"));
        String location = "inventory";
        if (args.hasAny("a")) {
            this.repairInventory((Inventory)pl.getInventory(), checkRestrictions, resultCount, lastItem);
        } else {
            RepairResult result;
            ItemStack stack;
            boolean repairMainhand;
            boolean repairHotbar = args.hasAny("h");
            boolean repairEquip = args.hasAny("e");
            boolean repairOffhand = args.hasAny("o");
            boolean bl = repairMainhand = args.hasAny("m") || !repairHotbar && !repairEquip && !repairOffhand;
            if (repairHotbar && !repairEquip && !repairOffhand && !repairMainhand) {
                location = "hotbar";
            } else if (repairEquip && !repairHotbar && !repairOffhand && !repairMainhand) {
                location = "equipment";
            } else if (repairOffhand && !repairHotbar && !repairEquip && !repairMainhand) {
                location = "offhand";
            } else if (repairMainhand && !repairHotbar && !repairEquip && !repairOffhand) {
                location = "mainhand";
            }
            if (repairMainhand && pl.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
                stack = (ItemStack)pl.getItemInHand(HandTypes.MAIN_HAND).get();
                result = this.repairStack(stack, checkRestrictions);
                resultCount.compute(result.type, (t, i) -> {
                    i = i + 1;
                    return i;
                });
                lastItem.put(result.type, result.stack.createSnapshot());
                if (result.isSuccessful()) {
                    pl.setItemInHand(HandTypes.MAIN_HAND, result.stack);
                }
            }
            if (repairOffhand && pl.getItemInHand(HandTypes.OFF_HAND).isPresent()) {
                stack = (ItemStack)pl.getItemInHand(HandTypes.OFF_HAND).get();
                result = this.repairStack(stack, checkRestrictions);
                resultCount.compute(result.type, (t, i) -> {
                    i = i + 1;
                    return i;
                });
                lastItem.put(result.type, result.stack.createSnapshot());
                if (result.isSuccessful()) {
                    pl.setItemInHand(HandTypes.OFF_HAND, result.stack);
                }
            }
            if (repairEquip) {
                this.repairInventory(pl.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(EquipmentInventory.class)}), checkRestrictions, resultCount, lastItem);
            }
            if (repairHotbar) {
                this.repairInventory(pl.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(Hotbar.class)}), checkRestrictions, resultCount, lastItem);
            }
        }
        location = Nucleus.getNucleus().getMessageProvider().getMessageFromKey("command.repair.location." + location).orElse("inventory");
        if ((Integer)resultCount.get((Object)ResultType.SUCCESS) == 0 && (Integer)resultCount.get((Object)ResultType.ERROR) == 0 && (Integer)resultCount.get((Object)ResultType.NO_DURABILITY) == 0 && (Integer)resultCount.get((Object)ResultType.RESTRICTED) == 0) {
            throw ReturnMessageException.fromKey("command.repair.empty", pl.getName(), location);
        }
        if ((Integer)resultCount.get((Object)ResultType.NO_DURABILITY) > 0 && (Integer)resultCount.get((Object)ResultType.SUCCESS) == 0 && (Integer)resultCount.get((Object)ResultType.ERROR) == 0 && (Integer)resultCount.get((Object)ResultType.RESTRICTED) == 0) {
            if ((Integer)resultCount.get((Object)ResultType.NO_DURABILITY) == 1) {
                ItemStackSnapshot item = lastItem.get((Object)ResultType.NO_DURABILITY);
                pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.repair.nodurability.single", new Text[]{((Text)item.get(Keys.DISPLAY_NAME).orElse(Text.of((String)item.getTranslation().get()))).toBuilder().onHover((HoverAction)TextActions.showItem((ItemStackSnapshot)item)).build(), Text.of((String)pl.getName()), Text.of((String)location)}));
            } else {
                pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.repair.nodurability.multiple", ((Integer)resultCount.get((Object)ResultType.NO_DURABILITY)).toString(), pl.getName(), location));
            }
        }
        if ((Integer)resultCount.get((Object)ResultType.SUCCESS) == 1) {
            ItemStackSnapshot item = lastItem.get((Object)ResultType.SUCCESS);
            pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.repair.success.single", new Text[]{((Text)item.get(Keys.DISPLAY_NAME).orElse(Text.of((String)item.getTranslation().get()))).toBuilder().onHover((HoverAction)TextActions.showItem((ItemStackSnapshot)item)).build(), Text.of((String)pl.getName()), Text.of((String)location)}));
        } else if ((Integer)resultCount.get((Object)ResultType.SUCCESS) > 1) {
            pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.repair.success.multiple", ((Integer)resultCount.get((Object)ResultType.SUCCESS)).toString(), pl.getName(), location));
        }
        if ((Integer)resultCount.get((Object)ResultType.ERROR) == 1) {
            ItemStackSnapshot item = lastItem.get((Object)ResultType.ERROR);
            pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.repair.error.single", new Text[]{((Text)item.get(Keys.DISPLAY_NAME).orElse(Text.of((String)item.getTranslation().get()))).toBuilder().onHover((HoverAction)TextActions.showItem((ItemStackSnapshot)item)).build(), Text.of((String)pl.getName()), Text.of((String)location)}));
        } else if ((Integer)resultCount.get((Object)ResultType.ERROR) > 1) {
            pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.repair.error.multiple", ((Integer)resultCount.get((Object)ResultType.ERROR)).toString(), pl.getName(), location));
        }
        if ((Integer)resultCount.get((Object)ResultType.RESTRICTED) == 1) {
            ItemStackSnapshot item = lastItem.get((Object)ResultType.RESTRICTED);
            pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.repair.restricted.single", new Text[]{((Text)item.get(Keys.DISPLAY_NAME).orElse(Text.of((String)item.getTranslation().get()))).toBuilder().onHover((HoverAction)TextActions.showItem((ItemStackSnapshot)item)).build(), Text.of((String)pl.getName()), Text.of((String)location)}));
        } else if ((Integer)resultCount.get((Object)ResultType.RESTRICTED) > 1) {
            pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.repair.restricted.multiple", ((Integer)resultCount.get((Object)ResultType.RESTRICTED)).toString(), pl.getName(), location));
        }
        return CommandResult.successCount((int)((Integer)resultCount.get((Object)ResultType.SUCCESS)));
    }

    private void repairInventory(Inventory inventory, boolean checkRestrictions, EnumMap<ResultType, Integer> resultCount, EnumMap<ResultType, ItemStackSnapshot> lastItem) {
        for (Inventory slot : inventory.slots()) {
            if (!slot.peek().isPresent() || ((ItemStack)slot.peek().get()).isEmpty()) continue;
            ItemStack stack = (ItemStack)slot.peek().get();
            RepairResult result = this.repairStack(stack, checkRestrictions);
            resultCount.compute(result.type, (t, i) -> {
                i = i + 1;
                return i;
            });
            lastItem.put(result.type, result.stack.createSnapshot());
            if (!result.isSuccessful()) continue;
            slot.set(result.stack);
        }
    }

    private RepairResult repairStack(ItemStack stack, boolean checkRestrictions) {
        if (checkRestrictions && (this.whitelist && !this.restrictions.contains(stack.getType()) || this.restrictions.contains(stack.getType()))) {
            return new RepairResult(stack, ResultType.RESTRICTED);
        }
        if (stack.get(DurabilityData.class).isPresent()) {
            DurabilityData durabilityData = (DurabilityData)stack.get(DurabilityData.class).get();
            DataTransactionResult transactionResult = stack.offer(Keys.ITEM_DURABILITY, durabilityData.durability().getMaxValue());
            if (transactionResult.isSuccessful()) {
                return new RepairResult(stack, ResultType.SUCCESS);
            }
            return new RepairResult(stack, ResultType.ERROR);
        }
        return new RepairResult(stack, ResultType.NO_DURABILITY);
    }

    private class RepairResult {
        private ItemStack stack;
        private ResultType type;

        public RepairResult(ItemStack stack, ResultType type) {
            this.stack = stack;
            this.type = type;
        }

        public boolean isSuccessful() {
            return this.type == ResultType.SUCCESS;
        }
    }

    private static enum ResultType {
        SUCCESS,
        ERROR,
        RESTRICTED,
        NO_DURABILITY;

    }
}

