/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.misc.commands;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.misc.config.MiscConfig;
import io.github.nucleuspowered.nucleus.modules.misc.config.MiscConfigAdapter;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@RegisterCommand(value={"speed"})
@Permissions(supportsOthers=true)
@EssentialsEquivalent(value={"speed", "flyspeed", "walkspeed", "fspeed", "wspeed"}, isExact=false, notes="This command either uses your current state or a specified argument to determine whether to alter fly or walk speed.")
public class SpeedCommand
extends AbstractCommand.SimpleTargetOtherPlayer
implements Reloadable {
    private final String speedKey = "speed";
    private final String resetKey = "reset";
    private final String typeKey = "type";
    public static final int multiplier = 20;
    private int maxSpeed = 5;

    @Override
    public void onReload() {
        this.maxSpeed = ((MiscConfig)((MiscConfigAdapter)this.getServiceUnchecked(MiscConfigAdapter.class)).getNodeOrDefault()).getMaxSpeed();
    }

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap mspi = Maps.newHashMap();
        mspi.put("exempt.max", PermissionInformation.getWithTranslation("permission.speed.exempt.max", SuggestedLevel.OWNER));
        return mspi;
    }

    @Override
    public CommandElement[] additionalArguments() {
        HashMap<String, SpeedType> keysMap = new HashMap<String, SpeedType>();
        keysMap.put("fly", SpeedType.FLYING);
        keysMap.put("flying", SpeedType.FLYING);
        keysMap.put("f", SpeedType.FLYING);
        keysMap.put("walk", SpeedType.WALKING);
        keysMap.put("w", SpeedType.WALKING);
        return new CommandElement[]{GenericArguments.optionalWeak((CommandElement)GenericArguments.onlyOne((CommandElement)GenericArguments.choices((Text)Text.of((String)this.typeKey), keysMap, (boolean)true))), GenericArguments.optional((CommandElement)GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.integer((Text)Text.of((String)this.speedKey)), GenericArguments.literal((Text)Text.of((String)this.resetKey), (String[])new String[]{this.resetKey})}))};
    }

    @Override
    public CommandResult executeWithPlayer(CommandSource src, Player pl, CommandContext args, boolean isSelf) {
        SpeedType key = args.getOne(this.typeKey).orElseGet(() -> pl.get(Keys.IS_FLYING).orElse(false) != false ? SpeedType.FLYING : SpeedType.WALKING);
        Integer speed = args.getOne(this.speedKey).orElseGet(() -> {
            if (args.hasAny(this.resetKey)) {
                return key == SpeedType.WALKING ? 2 : 1;
            }
            return null;
        });
        if (speed == null) {
            Text t = Text.builder().append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.speed.walk", new String[0])}).append(new Text[]{Text.of((String)" ")}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, Math.round(pl.get(Keys.WALKING_SPEED).orElse(0.1) * 20.0)})}).append(new Text[]{Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, ", "})}).append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.speed.flying", new String[0])}).build()}).append(new Text[]{Text.of((String)" ")}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, Math.round(pl.get(Keys.FLYING_SPEED).orElse(0.05) * 20.0)})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "."})}).build();
            src.sendMessage(t);
            return CommandResult.empty();
        }
        if (speed < 0) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.speed.negative", new String[0]));
            return CommandResult.empty();
        }
        if (!this.permissions.testSuffix((Subject)src, "exempt.max", src, true) && this.maxSpeed < speed) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.speed.max", String.valueOf(this.maxSpeed)));
            return CommandResult.empty();
        }
        DataTransactionResult dtr = pl.offer(key.speedKey, (Object)((double)speed.intValue() / 20.0));
        if (dtr.isSuccessful()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.speed.success.base", key.name, String.valueOf(speed)));
            if (!isSelf) {
                src.sendMessages(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.speed.success.other", pl.getName(), key.name, String.valueOf(speed))});
            }
            return CommandResult.success();
        }
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.speed.fail", key.name));
        return CommandResult.empty();
    }

    private static enum SpeedType {
        WALKING((Key<Value<Double>>)Keys.WALKING_SPEED, Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.walking", new String[0])),
        FLYING((Key<Value<Double>>)Keys.FLYING_SPEED, Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.flying", new String[0]));

        final Key<Value<Double>> speedKey;
        final String name;

        private SpeedType(Key<Value<Double>> speedKey, String name) {
            this.speedKey = speedKey;
            this.name = name;
        }
    }
}

